/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// UIComponents app class
    /// </summary>
    public class App : Application
    {
        /// <summary>
        /// Main view of UIComponents.
        /// </summary>
        private MainView mainView;

        /// <summary>
        /// The constructor of App
        /// </summary>
        public App()
        {
            mainView = new MainView();

            NavigationPage.SetHasBackButton(mainView, false);
            NavigationPage MainNavigationPage = new NavigationPage(mainView);

            // The root page of your application
            MainPage = MainNavigationPage;
        }

        /// <summary>
        /// Handle when your app starts
        /// </summary>
        protected override void OnStart()
        {
        }

        /// <summary>
        /// Handle when your app sleeps
        /// </summary>
        protected override void OnSleep()
        {
        }

        /// <summary>
        /// Handle when your app resumes
        /// </summary>
        protected override void OnResume()
        {
        }

        /// <summary>
        /// Refresh the screen, pop the top page, and push current page again.
        /// </summary>
        public async void RefreshScreen()
        {
            if (mainView.CurrentView == "Button")
            {
                await mainView.Navigation.PopAsync();
                await mainView.Navigation.PushAsync(new ButtonView());
            }
        }
    }
}
