/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// Entrance view of UIComponents, it contains a simple list for all widgets to test
    /// </summary>
    public class MainView : ContentPage
    {
        /// <summary>
        /// Get or Set this string which refer to current view.
        /// </summary>
        public string CurrentView { get; set; }

        /// <summary>
        /// The constructor of MainView class
        /// </summary>
        public MainView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "UIComponents";

            var list = new ListView();
            CurrentView = "MainView";

            /// <summary>
            /// This is list data source, more widgets will be added here in the future
            /// </summary>
            list.ItemsSource = new List<String>()
            {
                "ActivityIndicator",
                "BoxView",
                "Button",
                "CarouselPage",
                "DatePicker",
                "Editor",
                "Entry",
                "Grid",
                "Image",
                "Label",
                "ListView",
                "Picker",
                "Popup",
                "ProgressBar",
                "SearchBar",
                "Slider",
                "Stepper",
                "Switch",
                "TabbedPage",
                "TableView",
                "TimePicker",
            };

            /// <summary>
            /// List item event handler, go to widget page
            /// </summary>
            list.ItemTapped += async (sender, e) =>
            {
                if (e.Item.ToString() == "ActivityIndicator")
                {
                    await Navigation.PushAsync(new ActivityIndicatorView());
                }
                else if (e.Item.ToString() == "BoxView")
                {
                    await Navigation.PushAsync(new BoxViewView());
                }
                else if (e.Item.ToString() == "Button")
                {
                    await Navigation.PushAsync(new ButtonView());
                }
                else if (e.Item.ToString() == "CarouselPage")
                {
                    await Navigation.PushAsync(new CarouselPageView());
                }
                else if (e.Item.ToString() == "DatePicker")
                {
                    await Navigation.PushAsync(new DateView());
                }
                else if (e.Item.ToString() == "Editor")
                {
                    await Navigation.PushAsync(new EditorView());
                }
                else if (e.Item.ToString() == "Entry")
                {
                    await Navigation.PushAsync(new EntryView());
                }
                else if (e.Item.ToString() == "Grid")
                {
                    await Navigation.PushAsync(new GridV());
                }
                else if (e.Item.ToString() == "Image")
                {
                    await Navigation.PushAsync(new ImageView());
                }
                else if (e.Item.ToString() == "Label")
                {
                    await Navigation.PushAsync(new LabelView());
                }
                else if (e.Item.ToString() == "ListView")
                {
                    await Navigation.PushAsync(new ListV());
                }
                else if (e.Item.ToString() == "Picker")
                {
                    await Navigation.PushAsync(new PickerView());
                }
                else if (e.Item.ToString() == "Popup")
                {
                    await Navigation.PushAsync(new PopupView());
                }
                else if (e.Item.ToString() == "ProgressBar")
                {
                    await Navigation.PushAsync(new ProgressBarView());
                }
                else if (e.Item.ToString() == "SearchBar")
                {
                    await Navigation.PushAsync(new SearchBarView());
                }
                else if (e.Item.ToString() == "Slider")
                {
                    await Navigation.PushAsync(new SliderView());
                }
                else if (e.Item.ToString() == "Stepper")
                {
                    await Navigation.PushAsync(new StepperView());
                }
                else if (e.Item.ToString() == "Switch")
                {
                    await Navigation.PushAsync(new SwitchView());
                }
                else if (e.Item.ToString() == "TabbedPage")
                {
                    await Navigation.PushAsync(new TabbedPageView());
                }
                else if (e.Item.ToString() == "TableView")
                {
                    await Navigation.PushAsync(new TableViewV());
                }
                else if (e.Item.ToString() == "TimePicker")
                {
                    await Navigation.PushAsync(new TimeView());
                }

                // set current view string.
                CurrentView = e.Item.ToString();
            };

            this.Content = new StackLayout
            {
                Children =
                {
                    list,
                }
            };
        }
    }
}
