/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A simple view contains various entries to demostrate entry usages
    /// </summary>
    public class EntryView : ContentPage
    {
        public EntryView()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Entry";

            /// <summary>
            /// Init a singleLine entry
            /// </summary>
            Entry entry1 = new Entry
            {
                FontSize = 20,
                Text = "Entry only supports single line input",
            };
            /// <summary>
            /// Init a password entry
            /// </summary>
            Entry entry2 = new Entry
            {
                FontSize = 20,
                Text = "This is a Password Entry",
                IsPassword = true
            };

            /// <summary>
            /// Add a StackLayout to contain all widgets
            /// </summary>
            Content = new StackLayout
            {            
                Spacing = 60,
                Children =
                {
                    entry1,
                    entry2,
                }
            };
        }
    }
}
