/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a Editor, editor supports multi-line input
    /// </summary>
    public class EditorView : ContentPage
    {
        public EditorView() : base()
        {
            /// <summary>
            /// Set title of this page.
            /// </summary>
            Title = "Editor";

            /// <summary>
            /// Add a Editor to accept input
            /// </summary>
            Editor editor = new Editor
            {
                FontSize = 20,
                Text = "Editor supports multi-line input",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };

            /// <summary>
            /// Set editor as the content.
            /// </summary>
            Content = editor;
        }
    }
}

