/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A simple view contains BoxView to demostrate its usage
    /// </summary>
    public class BoxViewView : ContentPage
    {
        public BoxViewView()
        {
            /// <summary>
            /// Set title
            /// </summary>
            Title = "BoxView";

            /// <summary>
            /// Add first boxview as the content of the BoxViewView class
            /// </summary>
            BoxView boxView1 = new BoxView
            {
                Color = Color.Accent,
                WidthRequest = 150,
                HeightRequest = 150,
                HorizontalOptions = LayoutOptions.Center,
            };
            /// <summary>
            /// Add Second boxview as the content of the BoxViewView class
            /// </summary>
            BoxView boxView2 = new BoxView
            {
                Color = Color.Red,
                WidthRequest = 300,
                HeightRequest = 200,
                HorizontalOptions = LayoutOptions.Center,
            };

            /// <summary>
            /// The content of the BoxViewView class
            /// </summary>
            Content = new StackLayout
            {
                Spacing = 30,
                Children =
                {
                    boxView1,
                    boxView2,
                }
            };
        }
    }
}

