/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// a simple view contains a ProgressBar, user can change the value
    /// </summary>
    public class ProgressBarView : ContentPage
    {
        /// <summary>
        /// The constructor of ProgressBarView class
        /// </summary>
        public ProgressBarView()
        {
            ProgressBar progressBar = new ProgressBar()
            {
                Progress = 0.6,
            };

            /// <summary>
            /// If you click the button, ProgressBar will go back
            /// </summary>
            Button btnPrev = new Button()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "Prev",
            };
            btnPrev.Clicked += (s, e) =>
            {
                progressBar.Progress -= 0.1;
            };

            /// <summary>
            /// If you click the button, ProgressBar will go forward
            /// </summary>
            Button btnNext = new Button()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "Next",
            };
            btnNext.Clicked += (s, e) =>
            {
                progressBar.Progress += 0.1;
            };

            Label label = new Label()
            {
                 FontSize = 25,
                 HeightRequest = 150,
                 HorizontalOptions = LayoutOptions.FillAndExpand,
                 HorizontalTextAlignment = TextAlignment.Center,
            };

            /// <summary>
            /// Bind label with progressBar
            /// </summary>
            label.SetBinding(Label.TextProperty, new Binding("Progress") { StringFormat = "ProgressBar value : {0:F2}" });
            label.BindingContext = progressBar;

            StackLayout vLayout = new StackLayout()
            {
                Spacing = 50,
                Children =
                {
                    progressBar,
                    btnPrev,
                    btnNext,
                    label,
                },
            };

            Title = "ProgressBar";
            Content = vLayout;
        }
    }
}

