/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// A view contains a Picker, user can click picker to choose color
    /// </summary>
    public class PickerView : ContentPage
    {
        /// <summary>
        /// picker selected index
        /// </summary>
        int index = 0;

        /// <summary>
        /// Dictionary to get Color from color name
        /// </summary>
        Dictionary<string, Color> nameToColor = new Dictionary<string, Color>
        {
            { "Aqua", Color.Aqua },
            { "Black", Color.Black },
            { "Blue", Color.Blue },
            { "Gray", Color.Gray },
            { "Green", Color.Green },
            { "Lime", Color.Lime },
            { "Maroon", Color.Maroon },
            { "Navy", Color.Navy },
            { "Olive", Color.Olive },
            { "Purple", Color.Purple },
            { "Red", Color.Red },
            { "Silver", Color.Silver },
            { "Teal", Color.Teal },
            { "White", Color.White },
            { "Yellow", Color.Yellow }
        };

        /// <summary>
        /// The constructor of PickerView class
        /// </summary>
        public PickerView() : base()
        {
            /// <summary>
            /// Set the title of this page.
            /// </summary>
            Title = "Picker";

            Picker picker = new Picker
            {
                Title = "Color",
                SelectedIndex = index,
            };

            foreach (string colorName in nameToColor.Keys)
            {
                picker.Items.Add(colorName);
            }

            /// <summary>
            /// A boxView for displaying picker color
            /// </summary>
            BoxView boxView = new BoxView
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };

            /// <summary>
            /// Handle picker select event
            /// </summary>
            picker.SelectedIndexChanged += (sender, args) =>
            {
                if (picker.SelectedIndex == -1)
                {
                    index = 0;
                }
                else
                {
                    index = picker.SelectedIndex;
                }

                string colorName = picker.Items[index];
                boxView.Color = nameToColor[colorName];
            };

            Content = new StackLayout
            {
                Spacing = 30,
                Children =
                {
                    picker,
                    boxView
                }
            };

            // Set first color
            Appearing += (s, e) =>
            {
                picker.SelectedIndex = 0;
            };
        }
    }
}

