/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;

using Xamarin.Forms;

namespace UIComponents
{
    /// <summary>
    /// The most simple List that only contain a text in each cell
    /// </summary>
    public class List1Text : ContentPage
    {
        /// <summary>
        /// The constructor of List1Text class
        /// </summary>
        public List1Text()
        {
            var list = new ListView();
            list.ItemsSource = new List<String>()
            {
                "1Text-1",
                "1Text-2",
                "1Text-3"
            };

            Title = "1text";
            Content = list;
        }
    }
}
