tizen.Hybrid = function (lib) {
    var _localMessagePort, _remoteMessagePort, _localMessagePortWatchId,
        _startServiceCallback, _startMessagePortCallback;

    // START SERVICE
    var _startService = function (callback) {
        console.log('tizen.Hybrid.startService()');

        _startServiceCallback = callback || function () {};

        try {
            // Get applications contexts for applications that are currently running.
            tizen.application.getAppsContext(_onGetAppsContextSuccess, _onGetAppsContextError);
        } catch (e) {
            console.error('Error when trying to get running applications contexts');
        }
    };

    var _onGetAppsContextSuccess = function (contexts) {
        console.log('_onGetAppsContextSuccess()');

        var serviceId = lib.getServiceId();

        for (var i = 0; i < contexts.length; i++) {
            if (contexts[i].appId === serviceId) {
                break;
            }
        }

        if (i >= contexts.length) {
            // Service is not running. Trying to launch.
            _launchService();
        } else {
            // Service is running. Starting message port.
            _startServiceCallback();
        }
    };

    var _onGetAppsContextError = function () {
        console.log('_onGetAppsContextError()');

        console.error('Error when getting running applications contexts');
    };

    var _onLaunchSuccess = function () {
        console.log('_onLaunchSuccess()');

        _startServiceCallback();
    };
    var _onLaunchError = function () {
        console.log('_onLaunchError()');

        var serviceName = lib.getServiceName();

        console.error('Failed to launch service "' + serviceName + '"');

        _startServiceCallback({
            code: 'CANT_START_SERVICE'
        });
    };

    var _launchService = function () {
        console.log('_launchService()');

        var serviceId = lib.getServiceId(),
            serviceName = lib.getServiceName();

        // Running service not found. Trying to launch it.
        try {
            tizen.application.launch(serviceId, _onLaunchSuccess, _onLaunchError);
        } catch (e) {
            console.error('Error when launching service "' + serviceName + '" (' + serviceId + ')');
        }
    };

    // START MESSAGE PORT
    var _startMessagePort = function (callback) {
        console.log('tizen.Hybrid.startMessagePort()');

        _startMessagePortCallback = callback || function () {};

        var localMessagePortName = lib.getLocalMessagePortName(),
            serviceId = lib.getServiceId(),
            servicePortName = lib.getServicePortName();

        try {
            _localMessagePort = tizen.messageport.requestLocalMessagePort(localMessagePortName);
            _localMessagePortWatchId = _localMessagePort.addMessagePortListener(function (data, remote) {
                if (lib.onReceive && typeof lib.onReceive === 'function') {
                    lib.onReceive(data, remote);
                } else {
                    _onReceive(data, remote);
                }
            });
            console.log('Local message port received');
        } catch (e) {
            _startMessagePortCallback({
                code: 'CANT_GET_LOCAL_MESSAGE_PORT'
            });
            console.error('Error when requesting local messageport (' + e.name + ')');
        }

        try {
            _remoteMessagePort = tizen.messageport.requestRemoteMessagePort(serviceId, servicePortName);
            console.log('Remote message port received');
            _startMessagePortCallback();
        } catch (e) {
            _startMessagePortCallback({
                code: 'CANT_GET_REMOTE_MESSAGE_PORT'
            });
            console.error('Error when requesting remote messageport (' + e.name + ')');
        }
    };

    // SEND
    var _send = function (request, data) {
        _remoteMessagePort.sendMessage([{
            key: 'request',
            value: request
        }, {
            key: 'data',
            value: JSON.stringify(data)
        }], _localMessagePort);
    };

    // RECEIVE
    var _onReceive = function (data) {
        console.log('DATA: ' + JSON.stringify(data));
    };

    this.startService = _startService;
    this.startMessagePort = _startMessagePort;
    this.send = _send;
};
