tizen.wifidirect = (function () {
    var camelCaseRegEx = /([a-z])([A-Z])/g;

    var _hybrid = null,
        _callbacks = [],
        _listeners = [];

    var _Request = {
        INIT: 100,
        // Activation
        ACTIVATE: 0,
        DEACTIVATE: 1,
        // Scanning
        SCAN: 2,
        CANCEL_SCAN: 3,
        // Groups
        CREATE_GROUP: 4,
        LEAVE_GROUP: 5,
        GET_GROUP_CLIENT_INFO_LIST: 6,
        GET_GROUP_OWNER_INFO: 7,
        GET_GROUP_SETTING_INFO: 8,
        SET_GROUP_SETTING_INFO: 9,
        GET_LOCAL_DEVICE_INFO: 10,

        // Connection
        CONNECT: 11,
        CANCEL_CONNECT: 12,
        DISCONNECT: 13,
        // Sockets
        INIT_SOCKET: 14,
        // Messaging
        SEND_BROADCAST: 15,
        SEND_MESSAGE: 16,
        // Others
        ADD_EVENT_LISTENER: 17,
        IS_ACTIVATED: 18,
        IS_DISCOVERABLE: 19,
        SET_DEVICE_NAME: 20,
        GET_OPERATING_CHANNEL: 21,
        GET_WPS_CONFIGURATION_MODE_PREFERENCE: 22,
        SET_WPS_CONFIGURATION_MODE_PREFERENCE: 23
    };

    var _Response = {
        INIT: 100,
        // Activation
        ACTIVATE: 0,
        ACTIVATED: 1,
        DEACTIVATE: 2,
        DEACTIVATED: 3,
        // Scanning
        SCAN: 4,
        CANCEL_SCAN: 5,
        SCAN_COMPLETED: 6,
        // Groups
        CREATE_GROUP: 7,
        GROUP_CREATED: 8,
        LEAVE_GROUP: 9,
        GROUP_LEFT: 10,
        GET_GROUP_CLIENT_INFO_LIST: 11,
        GET_GROUP_OWNER_INFO: 12,
        GET_GROUP_SETTING_INFO: 13,
        SET_GROUP_SETTING_INFO: 14,
        GET_LOCAL_DEVICE_INFO: 15,
        // Connection
        CONNECT: 16,
        CONNECTED: 17,
        CANCEL_CONNECT: 18,
        DISCONNECT: 19,
        DISCONNECTED: 20,
        // Sockets
        INIT_SOCKET: 21,
        SOCKET_INITIALIZED: 22,
        // Messaging
        SEND_BROADCAST: 23,
        SEND_MESSAGE: 24,
        MESSAGE_RECEIVED: 25,
        // Others
        ADD_EVENT_LISTENER: 26,
        IS_ACTIVATED: 27,
        IS_DISCOVERABLE: 28,
        SET_DEVICE_NAME: 29,
        GET_OPERATING_CHANNEL: 30,
        GET_WPS_CONFIGURATION_MODE_PREFERENCE: 31,
        SET_WPS_CONFIGURATION_MODE_PREFERENCE: 32
    };

    var _WifiRadioChannel = {
        WIFI_RADIO_CHANNEL_1: 0,
        WIFI_RADIO_CHANNEL_2: 1,
        WIFI_RADIO_CHANNEL_3: 2,
        WIFI_RADIO_CHANNEL_4: 3,
        WIFI_RADIO_CHANNEL_5: 4,
        WIFI_RADIO_CHANNEL_6: 5,
        WIFI_RADIO_CHANNEL_7: 6,
        WIFI_RADIO_CHANNEL_8: 7,
        WIFI_RADIO_CHANNEL_9: 8,
        WIFI_RADIO_CHANNEL_10: 9,
        WIFI_RADIO_CHANNEL_11: 10,
        WIFI_RADIO_CHANNEL_12: 11,
        WIFI_RADIO_CHANNEL_13: 12,
        WIFI_RADIO_CHANNEL_14: 13
    };

    var _WifiWpsConfigurationMode = {
        WIFI_WPS_CONFIG_MODE_NONE: 0,
        WIFI_WPS_CONFIG_MODE_PIN_DISPLAY: 1,
        WIFI_WPS_CONFIG_MODE_PIN_KEYPAD: 2,
        WIFI_WPS_CONFIG_MODE_PBC: 3
    };

    var _serviceName = 'HybridWifiDirectService',
        _localMessagePortName = 'WEB',
        _servicePortName = 'SERVICE';

    var _getServiceId = function () {
        return tizen.application.getAppInfo().packageId + '.' + _serviceName;
    };

    var _getServiceName = function () {
        return _serviceName;
    };

    var _getLocalMessagePortName = function () {
        return _localMessagePortName;
    };

    var _getServicePortName = function () {
        return _servicePortName;
    };

    var _init = function (callback) {
        if (_hybrid) {
            _hybrid = null;
            _listeners = [];
            _callbacks = [];
        }

        _hybrid = new tizen.Hybrid(this);
        _hybrid.startService(function (error) {
            if (error) {
                alert(JSON.stringify(error));
            } else {
                _hybrid.startMessagePort(function (error) {
                    if (error) {
                        alert(JSON.stringify(error));
                    } else {
                        _addCallback('init', callback);
                        _hybrid.send(_Request.INIT);
                    }
                });
            }
        });
    };

    var _addCallback = function (callbackName, callback) {
        callbackName = callbackName.replace(camelCaseRegEx, '$1_$2').toUpperCase();

        if (!_Response.hasOwnProperty(callbackName)) {
            console.error('Callback with name "' + callbackName + '" does not exist');
            return;
        }
        if (!callback || typeof callback !== 'function') {
            console.error('Pass callback function as a second parameter');
            return;
        }

        _callbacks = _callbacks || {};
        _callbacks[callbackName] = _callbacks[callbackName] || [];
        _callbacks[callbackName].push(callback);
    };

    var _addEventListener = function (responseName, listener) {
        responseName = responseName.replace(camelCaseRegEx, '$1_$2').toUpperCase();

        if (!_Response.hasOwnProperty(responseName)) {
            console.error('Event with name "' + responseName + '" does not exist');
            return;
        }
        if (!listener || typeof listener !== 'function') {
            console.error('Pass listener function as a second parameter');
            return;
        }

        _listeners = _listeners || {};
        _listeners[responseName] = _listeners[responseName] || [];
        _listeners[responseName].push(listener);
    };

    var _activate = function (callback) {
        _addCallback('activate', callback);
        _hybrid.send(_Request.ACTIVATE);
    };

    var _deactivate = function (callback) {
        _addCallback('deactivate', callback);
        _hybrid.send(_Request.DEACTIVATE);
    };

    var _isActivated = function (callback) {
        _addCallback('isActivated', callback);
        _hybrid.send(_Request.IS_ACTIVATED);
    };

    var _isDiscoverable = function (callback) {
        _addCallback('isDiscoverable', callback);
        _hybrid.send(_Request.IS_DISCOVERABLE);
    };

    var _scan = function (callback) {
        _addCallback('scan', callback);
        _hybrid.send(_Request.SCAN);
    };

    var _cancelScan = function (callback) {
        _addCallback('cancelScan', callback);
        _hybrid.send(_Request.CANCEL_SCAN);
    };

    var _connect = function (deviceInfo, callback) {
        console.log('Connecting to: ' + JSON.stringify(deviceInfo));
        _addCallback('connect', callback);
        _hybrid.send(_Request.CONNECT, deviceInfo);
    };

    var _cancelConnect = function (callback) {
        _addCallback('cancelConnect', callback);
        _hybrid.send(_Request.CANCEL_CONNECT);
    };

    var _disconnect = function (deviceInfo, callback) {
        _addCallback('disconnect', callback);
        _hybrid.send(_Request.DISCONNECT, deviceInfo);
    };

    var _createGroup = function (callback) {
        _addCallback('createGroup', callback);
        _hybrid.send(_Request.CREATE_GROUP);
    };

    var _leaveGroup = function (callback) {
        _addCallback('leaveGroup', callback);
        _hybrid.send(_Request.LEAVE_GROUP);
    };

    var _getGroupClientInfoList = function (callback) {
        _addCallback('getGroupClientInfoList', callback);
        _hybrid.send(_Request.GET_GROUP_CLIENT_INFO_LIST);
    };

    var _getGroupOwnerInfo = function (callback) {
        _addCallback('getGroupOwnerInfo', callback);
        _hybrid.send(_Request.GET_GROUP_OWNER_INFO);
    };

    var _getGroupSettingInfo = function (callback) {
        _addCallback('getGroupSettingInfo', callback);
        _hybrid.send(_Request.GET_GROUP_SETTING_INFO);
    };

    var _setGroupSettingInfo = function (wifiDirectGroupInfo, callback) {
        _addCallback('setGroupSettingInfo', callback);
        _hybrid.send(_Request.SET_GROUP_SETTING_INFO, wifiDirectGroupInfo);
    };

    var _setLocalDeviceName = function (deviceName, callback) {
        console.log("setLocalDeviceName");
        _addCallback('setDeviceName', callback);
        _hybrid.send(_Request.SET_DEVICE_NAME, {
            deviceName: deviceName
        });
    };

    var _getLocalDeviceInfo = function (callback) {
        _addCallback('getLocalDeviceInfo', callback);
        _hybrid.send(_Request.GET_LOCAL_DEVICE_INFO);
    };

    var _getOperatingChannel = function (callback) {
        _addCallback('getOperatingChannel', callback);
        _hybrid.send(_Request.GET_OPERATING_CHANNEL);
    };

    var _getWpsConfigurationModePreference = function (callback) {
        _addCallback('getWpsConfigurationModePreference', callback);
        _hybrid.send(_Request.GET_WPS_CONFIGURATION_MODE_PREFERENCE);
    };

    var _setWpsConfigurationModePreference = function (wifiWpsConfigurationMode, callback) {
        console.log("_setWpsConfigurationModePreference " + wifiWpsConfigurationMode);
        _addCallback('setWpsConfigurationModePreference', callback);
        _hybrid.send(_Request.SET_WPS_CONFIGURATION_MODE_PREFERENCE, {
            confMode: wifiWpsConfigurationMode
        });
    };

    var _initSocket = function (callback) {
        _addCallback('initSocket', callback);
        _hybrid.send(_Request.INIT_SOCKET);
    };

    var _sendMessage = function (ipAddress, message, callback) {
        _addCallback('sendMessage', callback);
        _hybrid.send(_Request.SEND_MESSAGE, {
            ipAddress: ipAddress,
            message: message
        });
    };

    var _sendBroadcast = function (message, callback) {
        _addCallback('sendBroadcast', callback);
        _hybrid.send(_Request.SEND_BROADCAST, {
            message: message
        });
    };

    var _parse = function (data) {
        if (data[0].key === 'json') {
            return JSON.parse(data[0].value);
        }

        return data;
    };

    var _onReceive = function (data) {
        var json = _parse(data),
            response = json.response,
            error = json.error;

        console.log('JSON: ' + JSON.stringify(json));

        var responseName;

        for (var name in _Response) {
            if (_Response[name] === response) {
                responseName = name;
                break;
            }
        }

        console.log('responseName: ' + responseName);

        if (responseName) {
            var i, cnt;

            if (_listeners[responseName]) {
                console.log('Running "' + responseName + '" listeners...');
                for (i = 0, cnt = _listeners[responseName].length; i < cnt; i++) {
                    _listeners[responseName][i](error, json.data);
                }
            } else if (_callbacks[responseName]) {
                console.log('Running "' + responseName + '" callbacks...');
                for (i = 0, cnt = _callbacks[responseName].length; i < cnt; i++) {
                    _callbacks[responseName].shift()(error, json.data);
                }
            }
        }
    };

    return {
        WifiRadioChannel: _WifiRadioChannel,
        WifiWpsConfigurationMode: _WifiWpsConfigurationMode,

        getServiceId: _getServiceId,
        getServiceName: _getServiceName,
        getLocalMessagePortName: _getLocalMessagePortName,
        getServicePortName: _getServicePortName,
        init: _init,
        activate: _activate,
        deactivate: _deactivate,
        isActivated: _isActivated,
        isDiscoverable: _isDiscoverable,
        scan: _scan,
        cancelScan: _cancelScan,
        connect: _connect,
        cancelConnect: _cancelConnect,
        disconnect: _disconnect,

        createGroup: _createGroup,
        leaveGroup: _leaveGroup,
        getGroupClientInfoList: _getGroupClientInfoList,
        getGroupOwnerInfo: _getGroupOwnerInfo,
        getGroupSettingInfo: _getGroupSettingInfo,
        setGroupSettingInfo: _setGroupSettingInfo,
        setLocalDeviceName: _setLocalDeviceName,
        getLocalDeviceInfo: _getLocalDeviceInfo,
        getOperatingChannel: _getOperatingChannel,
        getWpsConfigurationModePreference: _getWpsConfigurationModePreference,
        setWpsConfigurationModePreference: _setWpsConfigurationModePreference,

        initSocket: _initSocket,
        sendBroadcast: _sendBroadcast,
        sendMessage: _sendMessage,

        addEventListener: _addEventListener,
        onReceive: _onReceive,
    };
}());
