/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
var app = (function () {
    'use strict';

    var _$box,
        _animated,
        _transitionValues,
        _defaultValues,
        _property,
        _easing,
        _duration,
        _delay,
        _transition,
        _setProperty,
        _setEasing,
        _setDuration,
        _setDelay,
        _init;

    /* Initial values. */
    _animated = false;
    _transitionValues = {
        scale     : { scale    : 1.5 },
        rotate    : { rotate   : '180deg' },
        rotateX   : { rotateX  : '180deg' },
        rotateY   : { rotateY  : '180deg' },
        rotateZ   : { rotateZ  : '180deg' },
        rotate3d  : { rotate3d : '1,1,0,180deg' },
        transform : { x : '100', y : '100' },
        skewX     : { skewX : '30deg' },
        skewY     : { skewY : '30deg' },
        opacity   : { opacity : 0.25 },
        borderrad : { borderRadius : '150px' }
    };
    _defaultValues = {
        scale     : { scale    : 1 },
        rotate    : { rotate   : '0deg' },
        rotateX   : { rotateX  : '0deg' },
        rotateY   : { rotateY  : '0deg' },
        rotateZ   : { rotateZ  : '0deg' },
        rotate3d  : { rotate3d : '1,1,0,0deg' },
        transform : { x : '0', y : '0' },
        skewX     : { skewX : '0deg' },
        skewY     : { skewY : '0deg' },
        opacity   : { opacity : 1 },
        borderrad : { borderRadius : '15px' }
    };
    _property = 'transform';
    _easing   = 'ease';
    _duration = 500;
    _delay    = 300;

    /**
     * Perform transition in and out.
     */
    _transition = function () {
        var transitionInComplete,
            transitionOutComplete,
            options;

        /* Don't perform transition if another one is already taking place. */
        if (_animated) {
            return;
        }

        /* Wrap animation execution with function to make sure that transition
         * options does not change over time. */
        (function executeAnimation (property, easing, duration, delay) {
            /* Callback function to execute after transition in is finished. */
            transitionInComplete = function () {
                var options;

                /* Prepare options to transition out. */
                options = { easing : easing, duration : duration, delay: delay, complete : transitionOutComplete };
                options = $.extend(options, _defaultValues[property]);
                _$box.transition(options);
            };

            /* Callback function to execute after transition out is finished. */
            transitionOutComplete = function () {
                _animated = false;
            };

            /* Prepare options for transition in. */
            options = { easing : easing, duration : duration, delay: delay, complete : transitionInComplete };
            options = $.extend(options, _transitionValues[property]);
            _animated = true;
            _$box.transition(options);
        }(_property, _easing, _duration, _delay));
    };

    _setProperty = function (property) {
        _property = property;
    };

    _setDuration = function (duration) {
        _duration = duration;
    };

    _setEasing = function (easing) {
        _easing = easing;
    };

    _setDelay = function (delay) {
        _delay = delay;
    };

    _init = function () {
        var fields,
            listener;

        /* Get all fields. */
        fields = {
            property : document.getElementById('property-field'),
            easing   : document.getElementById('easing-field'),
            duration : document.getElementById('duration-field'),
            delay    : document.getElementById('delay-field')
        };

        /* Common listener for all fields */
        listener = function () {
            var field,
                id,
                value,
                functionName;

            /* Determine which field was taped and get its id and value. */
            field = this;
            id = field.getAttribute('id').replace('-field', '');
            value = this.value;
            functionName = 'set' + id.charAt(0).toUpperCase() + id.substr(1);

            /* Set value in application API for taped field. */
            app[functionName](value);
        };

        /* Bind listener to fields. */
        fields.property.addEventListener('change', listener, false);
        fields.easing.addEventListener('change', listener, false);
        fields.duration.addEventListener('change', listener, false);
        fields.delay.addEventListener('change', listener, false);

        $(fields.duration).on('slidestop', listener);
        $(fields.delay).on('slidestop', listener);

        /* Bind transition to click/tap event for the box. */
        _$box = $('#box');
        _$box.bind({
            click : function onBoxClickListener () {
                _transition();
            }
        });
    };

    return {
        init        : _init,
        setProperty : _setProperty,
        setEasing   : _setEasing,
        setDuration : _setDuration,
        setDelay    : _setDelay
    };
}());

window.onload = app.init;