/*******************************************************************************
 * Responsible for drawing figures: square, circle, triangle & polygons
 *
 * @author Zaneta Szymanska <<ahref='mailto:z.szymanska@samsung.com'>z.szymanska@samsung.com</a>>
 *
 * **************************************************************************************
 *
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 *
 ******************************************************************************/
"use strict";
var Figures = function(x, y) {

    this.square = function() {
        var rect = new fabric.Rect({
            width : 100,
            height : 100,
            left : x,
            top : y,
            selectable : false
        });

        if (stroke) {
            rect.set('fill', 'rgba(255,255,255,0)');
            rect.set('stroke', actualColor.css('background-color'));
            rect.set('strokeWidth', parseInt($('#line-width').text(), 10) || 1);
        } else {
            rect.set('fill', actualColor.css('background-color'));
        }

        return rect;
    };

    this.circle = function() {
        var circle = new fabric.Circle({
            radius : 50,
            left : x,
            top : y,
            opacity : 1,
            selectable : false
        });

        if (stroke) {
            circle.set('fill', 'rgba(255,255,255,0)');
            circle.set('stroke', actualColor.css('background-color'));
            circle.set('strokeWidth',
                    parseInt($('#line-width').text(), 10) || 1);
        } else {
            circle.set('fill', actualColor.css('background-color'));
        }

        return circle;
    };

    this.triangle = function() {
        var triangle = new fabric.Triangle({
            left : x,
            top : y,
            width : 100,
            height : 100,
            opacity : 1,
            selectable : false
        });

        if (stroke) {
            triangle.set('fill', 'rgba(255,255,255,0)');
            triangle.set('stroke', actualColor.css('background-color'));
            triangle.set('strokeWidth',
                    parseInt($('#line-width').text(), 10) || 1);
        } else {
            triangle.set('fill', actualColor.css('background-color'));
        }

        return triangle;
    };

    this.polygon = function() {

        var points = [];
        var count = parseInt($('#vertex-count').text(), 10);

        switch (count) {
        case 4:
            points.push({
                x : -50,
                y : -50
            }, {
                x : -50,
                y : 50
            }, {
                x : 50,
                y : 50
            }, {
                x : 50,
                y : -50
            });
            break;

        case 5:
            points.push({
                x : -50,
                y : -25
            }, {
                x : 0,
                y : -60
            }, {
                x : 50,
                y : -25
            }, {
                x : 25,
                y : 25
            }, {
                x : -25,
                y : 25
            });
            break;

        case 6:
            points.push({
                x : -50,
                y : -25
            }, {
                x : 0,
                y : -50
            }, {
                x : 50,
                y : -25
            }, {
                x : 50,
                y : 25
            }, {
                x : 0,
                y : 50
            }, {
                x : -50,
                y : 25
            });
            break;

        case 7:
            points.push({
                x : -50,
                y : -25
            }, {
                x : 0,
                y : -50
            }, {
                x : 50,
                y : -25
            }, {
                x : 50,
                y : 25
            }, {
                x : 25,
                y : 50
            }, {
                x : -25,
                y : 50
            }, {
                x : -50,
                y : 25
            });
            break;

        case 8:
            points.push({
                x : -75,
                y : -25
            }, {
                x : -25,
                y : -75
            }, {
                x : 25,
                y : -75
            }, {
                x : 75,
                y : -25
            }, {
                x : 75,
                y : 25
            }, {
                x : 25,
                y : 75
            }, {
                x : -25,
                y : 75
            }, {
                x : -75,
                y : 25
            });
            break;

        case 9:
            points.push({
                x : -75,
                y : -25
            }, {
                x : -25,
                y : -25
            }, {
                x : -25,
                y : -75
            }, {
                x : 25,
                y : -75
            }, {
                x : 75,
                y : -25
            }, {
                x : 75,
                y : 25
            }, {
                x : 25,
                y : 75
            }, {
                x : -25,
                y : 75
            }, {
                x : -75,
                y : 25
            });
            break;

        case 10:
            points.push({
                x : -60,
                y : -20
            }, {
                x : -20,
                y : -20
            }, {
                x : 0,
                y : -60
            }, {
                x : 20,
                y : -20
            }, {
                x : 60,
                y : -20
            }, {
                x : 20,
                y : 0
            }, {
                x : 40,
                y : 40
            }, {
                x : 0,
                y : 20
            }, {
                x : -40,
                y : 40
            }, {
                x : -20,
                y : 0
            });
            break;

        case 11:
            points.push({
                x : -75,
                y : -25
            }, {
                x : -25,
                y : -25
            }, {
                x : -25,
                y : -75
            }, {
                x : 25,
                y : -75
            }, {
                x : 25,
                y : -25
            }, {
                x : 75,
                y : -25
            }, {
                x : 75,
                y : 25
            }, {
                x : 25,
                y : 25
            }, {
                x : 25,
                y : 75
            }, {
                x : -25,
                y : 75
            }, {
                x : -75,
                y : 25
            });
            break;

        case 12:
            points.push({
                x : -75,
                y : -25
            }, {
                x : -25,
                y : -25
            }, {
                x : -25,
                y : -75
            }, {
                x : 25,
                y : -75
            }, {
                x : 25,
                y : -25
            }, {
                x : 75,
                y : -25
            }, {
                x : 75,
                y : 25
            }, {
                x : 25,
                y : 25
            }, {
                x : 25,
                y : 75
            }, {
                x : -25,
                y : 75
            }, {
                x : -25,
                y : 25
            }, {
                x : -75,
                y : 25
            });
            break;

        default:
            break;
        }

        var poly = new fabric.Polygon(points, {
            left : x,
            top : y,
            opacity : 1,
            selectable : false
        });

        if (stroke) {
            poly.set('fill', 'rgba(255,255,255,0)');
            poly.set('stroke', actualColor.css('background-color'));
            poly.set('strokeWidth', parseInt($('#line-width').text(), 10) || 1);
        } else {
            poly.set('fill', actualColor.css('background-color'));
        }

        return poly;
    };
};