package org.tizen.gwt.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Main implements OutputConsole {

	public static void main(String[] args) throws IOException {
		Main mainConsole = new Main();
		try {
			GwtModuleInfo moduleInfo = GwtModuleInfo.forName(mainConsole.textInput("GWT module name: "));
			ProjectBootstrapper bootstrapper = new ProjectBootstrapper(mainConsole);
			bootstrapper.bootstrapBuildFiles(moduleInfo);
			bootstrapper.bootstrapProjectFiles(moduleInfo);
		} 
		catch (IllegalArgumentException e) {
			mainConsole.logError(errMessage(e));
			System.exit(-1);
		}
	}
	
	private static String errMessage(Exception e) {
		String errMessage = e.getMessage();
		return errMessage == null || (errMessage = errMessage.trim()).length() == 0 ? 
				e.getClass().getName() : e.getClass().getName() + ": " + errMessage;
	}

	private BufferedReader mInReader;

	@Override
	public void logInfo(String msg) {
		System.out.println(msg);
	}

	@Override
	public void logError(String msg) {
		System.err.println(msg);
	}

	@Override
	public boolean prompt(String prompt) {
		return "Y".equalsIgnoreCase(textInput(prompt + " [Y or N]"));
	}

	@Override
	public String textInput(String string) {
		System.out.println(string);
		return readLine();
	}

	private String readLine() {
		if(mInReader == null) {
			mInReader = new BufferedReader(new InputStreamReader(System.in));
		}
		try {
			return mInReader.readLine();
		} 
		catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
