package org.tizen.gwt.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.tizen.gwt.ant.XpathUtil.ReplaceEntry;
import org.xml.sax.SAXException;

public class XPathReplaceTask extends Task {

	private String mFile;
	private String mNewfile;
	private List<ReplaceEntry> mEntries;

	@Override
	public void execute() throws BuildException {
		if(mEntries != null && mEntries.size() > 0) {
			try {
				XpathUtil.replaceByXpath(new File(mFile), mNewfile == null ? 
						null : new File(mNewfile), mEntries);
			} 
			catch (SAXException | IOException | ParserConfigurationException | 
					XPathExpressionException | TransformerException | 
					TransformerFactoryConfigurationError e) {
				throw new BuildException(e);
			}
		}
	}
	
	public void setFile(String file) {
		mFile = file;
	}

	public void setNewfile(String newfile) {
		mNewfile = newfile;
	}
	
	public void addConfiguredEntry(ReplaceEntry entry) {
		if(mEntries == null) {
			mEntries = new ArrayList<ReplaceEntry>();
		}
		mEntries.add(entry);
	}
}
