package org.tizen.gwt.ant;

import java.util.Random;

public class TizenIdUtil {

	private static final int N = 10 + 26 + 26; //[0-9] + [a-z] + [A-Z]
	
	public static String generateId(int length) {
		Random random = new Random();
		StringBuilder sb = new StringBuilder();
		for(int i=0;i<length;i++) {
			sb.append(randToChar(random.nextInt(N)));
		}
		return sb.toString();
	}
	
	private static char randToChar(int r) {
		if(r < 10) { //[0-9]
			return (char) (r + 48);
		}
		r -= 10;
		if(r < 26) { //[a-z]
			return (char) (r + 65);
		}
		r -= 26;
		if(r < 26) { //[A-Z]
			return (char) (r + 97);
		}
		throw new IllegalArgumentException("Value in range <0, 62> expected");
	}
}
