package org.tizen.gwt.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class TizenIdSetGen extends Task {

	private static final int GEN_LENGTH = 10;
	private String mAppname;
	private String mPackageidproperty;
	private String mAppidproperty;

	@Override
	public void execute() throws BuildException {
		String packageId = TizenIdUtil.generateId(GEN_LENGTH);
		Project p = getProject();
		p.setProperty(mPackageidproperty, packageId);
		p.setProperty(mAppidproperty, packageId + "." + mAppname);
	}
	
	public void setAppname(String appname) {
		mAppname = appname;
	}
	
	public void setPackageidproperty(String packageidproperty) {
		mPackageidproperty = packageidproperty;
	}
	
	public void setAppidproperty(String appidproperty) {
		mAppidproperty = appidproperty;
	}
}
