package org.tizen.gwt.bootstrap;

public class GwtModuleInfo {
	
	public static final String MODULE_NAME_REGEXP = "(?:[_\\$a-zA-Z][_\\$a-zA-Z0-9]*\\.)+[_\\$a-zA-Z0-9]+";

	public static GwtModuleInfo forName(String moduleName) throws IllegalArgumentException {
		int lastDotIndex = moduleName.lastIndexOf(".");
		validateModuleName(moduleName);
		return new GwtModuleInfo(
				moduleName.substring(0, lastDotIndex), 
				moduleName.substring(lastDotIndex + 1));
	}
	
	public static void validateModuleName(String value) throws IllegalArgumentException {
		if(value == null || "".equals(value)) {
			throw new IllegalArgumentException("Gwt Module Name must not be empty!");
		}
		if(!value.matches(MODULE_NAME_REGEXP)) {
			throw new IllegalArgumentException("Gwt Module Name should match regexp: " + MODULE_NAME_REGEXP);
		}
	}

	private final String mPackageName;
	private final String mEntryPointName;
	
	protected GwtModuleInfo(String packageName, String entryPointName) {
		mPackageName = packageName;
		mEntryPointName = entryPointName;
	}

	@Override
	public String toString() {
		return mPackageName.length() == 0 ? mEntryPointName : 
			mPackageName + "." + mEntryPointName;
	}

	public String getEntryPointName() {
		return mEntryPointName;
	}

	public String getPackageName() {
		return mPackageName;
	}
	
	public String getClientPackageName() {
		return mPackageName.length() == 0 ? "client" : mPackageName + ".client";
	}
	
	public String getEntryPointFullName() {
		return getClientPackageName() + "." + mEntryPointName;
	}
	
	public String getModuleRenameTo() {
		return mEntryPointName.toLowerCase();
	}
	
	public String getW3CWidgetId() {
		String[] splitted = mPackageName.split("\\.");
		if(splitted.length > 0) {
			StringBuilder sb = new StringBuilder().append(splitted[0]);
			int i=1;
			for( ; i < splitted.length && i < 3; i++) {
				sb.insert(0, ".").insert(0, splitted[i]);
			}
			sb.insert(0, "http://");
			for( ; i < splitted.length; i++) {
				sb.append("/").append(splitted[i]);
			}
			return sb.append("/").append(mEntryPointName).toString();
		}
		else {
			return mEntryPointName;
		}
	}
}