package org.tizen.gwt.ant;

import java.io.File;
import java.io.FileNotFoundException;

import javax.xml.xpath.XPathExpressionException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class XPathQueryTask extends Task {

	private String mFile;
	private String mOutput;
	private String mXpath;

	@Override
	public void execute() throws BuildException {
		try {
			getProject().setProperty(mOutput, 
					XpathUtil.queryByXpath(new File(mFile), mXpath));
		} 
		catch (FileNotFoundException | XPathExpressionException e) {
			throw new BuildException(e);
		}
	}
	
	public void setFile(String file) {
		mFile = file;
	}

	public void setOutput(String output) {
		mOutput = output;
	}

	public void setXpath(String xpath) {
		mXpath = xpath;
	}
}
