/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.gwt.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.tizen.gwt.ant.TizenIdUtil;
import org.tizen.gwt.bootstrap.GwtModuleInfo;
import org.tizen.gwt.bootstrap.OutputConsole;

public class ProjectBootstrapper {
    private static final String SELF_JAR_PATH = ProjectBootstrapper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
    private static final String ROOT_PATH = new File(SELF_JAR_PATH).getParent();
    private final OutputConsole mOutputConsole;

    public ProjectBootstrapper(OutputConsole outputConsole) {
        this.mOutputConsole = outputConsole;
    }

    public void bootstrapBuildFiles(GwtModuleInfo moduleInfo) throws IOException {
        File buildXml;
        File buildProperties = this.getCopyTarget("build.properties");
        if (this.overrideExisting(buildProperties)) {
            this.copyTextFile("templates/build.properties", buildProperties, null);
        }
        if (this.overrideExisting(buildXml = this.getCopyTarget("build.xml"))) {
            this.copyTextFile("templates/build.xml", buildXml, new String[][]{{"__GWT_ENTRYPOINT_NAME__", moduleInfo.getEntryPointName()}, {"__GWT_PACKAGE_NAME__", moduleInfo.getPackageName()}, {"__SELF_JAR__", SELF_JAR_PATH}});
        }
    }

    public void bootstrapProjectFiles(GwtModuleInfo moduleInfo) throws IOException {
        File iconPng;
        File indexHtml;
        File moduleGwtXml;
        File entryPointJava;
        File webXml;
        File configXml = this.getCopyTarget("config.xml");
        if (this.overrideExisting(configXml)) {
            this.copyTextFile("templates/config.xml", configXml, new String[][]{{"${ENTRY_POINT_NAME}", moduleInfo.getEntryPointName()}, {"${TIZEN_PACKAGE_ID}", TizenIdUtil.generateId(10)}, {"${W3C_WIDGET_ID}", moduleInfo.getW3CWidgetId()}});
        }
        if (!(webXml = this.getCopyTarget("war/WEB-INF/web.xml")).exists()) {
            this.copyTextFile("templates/web.xml", webXml, null);
        }
        if (this.overrideExisting(entryPointJava = this.getCopyTarget(this.getEntryPointPath(moduleInfo)))) {
            this.copyTextFile("templates/ENTRY_POINT.java.tpl", entryPointJava, new String[][]{{"${PACKAGE}", moduleInfo.getClientPackageName()}, {"${ENTRY_POINT}", moduleInfo.getEntryPointName()}});
        }
        if (this.overrideExisting(moduleGwtXml = this.getCopyTarget(this.getModuleDescriptorPath(moduleInfo)))) {
            this.copyTextFile("templates/MODULE_NAME.gwt.xml", moduleGwtXml, new String[][]{{"${GWT_ENTRY_POINT_CLASS}", moduleInfo.getEntryPointFullName()}, {"${GWT_RENAME_TO}", moduleInfo.getModuleRenameTo()}});
        }
        if (this.overrideExisting(indexHtml = this.getCopyTarget("war/index.html"))) {
            this.copyTextFile("templates/index.html", indexHtml, new String[][]{{"${GWT_RENAME_TO}", moduleInfo.getModuleRenameTo()}, {"${PAGE_TITLE}", moduleInfo.getEntryPointName()}});
        }
        if (this.overrideExisting(iconPng = this.getCopyTarget("war/icon.png"))) {
            this.copy("templates/icon.png", iconPng);
        }
    }

    private String getEntryPointPath(GwtModuleInfo moduleInfo) {
        return "src/" + moduleInfo.getClientPackageName().replaceAll("\\.", "/") + "/" + moduleInfo.getEntryPointName() + ".java";
    }

    private String getModuleDescriptorPath(GwtModuleInfo moduleInfo) {
        return "src/" + moduleInfo.getPackageName().replaceAll("\\.", "/") + "/" + moduleInfo.getEntryPointName() + ".gwt.xml";
    }

    private File getCopyTarget(String outputPath) {
        return new File(ROOT_PATH + "/" + outputPath);
    }

    private boolean overrideExisting(File file) {
        if (file.exists()) {
            return this.mOutputConsole.prompt("Should overwrite existing file \"" + file.getPath() + "\"?");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTextFile(String resName, File outputFile, String[][] replacements) throws IOException {
        BufferedReader in = null;
        OutputStreamWriter out = null;
        try {
            String line;
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            in = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resName)));
            out = new FileWriter(outputFile);
            while ((line = in.readLine()) != null) {
                if (replacements != null) {
                    for (String[] pair : replacements) {
                        line = line.replace(pair[0], pair[1]);
                    }
                }
                out.write(line + System.lineSeparator());
            }
            out.flush();
            this.mOutputConsole.logInfo("Created file: " + outputFile.getPath());
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String resName, File outputFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int b;
            in = this.getClass().getClassLoader().getResourceAsStream(resName);
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(outputFile);
            while ((b = in.read()) > -1) {
                out.write(b);
            }
            out.flush();
            this.mOutputConsole.logInfo("Created file: " + outputFile.getPath());
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception c) {}
        }
    }
}

