#include "nativeadsample.h"
#include "adlib.h"
#include "system_info.h"
#include "notification.h"

typedef struct appdata{
	Evas_Object* win;
	Evas_Object* layout;
	Evas_Object* conform;
	Evas_Object *banner_handle;
	Evas_Object *btn;
	Ecore_Timer *timer;
} appdata_s;

static void
win_delete_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	adlib_deinit();
	ui_app_exit();
}

static void
layout_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}

static void
app_get_resource(const char *edj_file_in, char *edj_path_out, int edj_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(edj_path_out, edj_path_max, "%s%s", res_path, edj_file_in);
		free(res_path);
	}
}


static void
btn_clicked_cb(void *data, Evas_Object *obj, void *event_info)
{
	adview_interstitial_show();
}

void on_interstitial_ad_succeeded(void *user_data)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_interstitial_ad_succeeded");
	appdata_s *ad = user_data;
	elm_object_text_set(ad->btn, "ClickToShow");
	return;
}

void on_banner_ad_succeeded(Evas_Object *obj, void *userdata)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_banner_request_succeeded");
	evas_object_show(obj);



}
void on_banner_ad_failed(Evas_Object *obj, adlib_err err, void *userdata)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_banner_request_failed_event_cb");
	appdata_s *ad = (appdata_s*)userdata;

	if(ad->banner_handle == obj)
	{
		notification_status_message_post("BannerAd Small fetch failed");
	}
	else
	{
		notification_status_message_post("BannerAd Big fetch failed");
	}
}
void on_banner_ad_opened(Evas_Object *obj, void *userdata)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_banner_ad_opened_event_cb");
}
void on_interstitial_ad_failed(adlib_err err, void *user_data)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_interstitial_ad_failed");
	notification_status_message_post("Interstitial Ad fetch failed");
	return;
}

void on_interstitial_ad_opened(void *user_data)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_interstitial_ad_opened");
	return;
}
void on_interstitial_ad_closed(void *user_data)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "on_interstitial_ad_closed");
	appdata_s *ad = user_data;
	elm_object_text_set(ad->btn, "ClickToShow");
	adview_interstitial_load();
	return;
}

static void
create_interstitial_ad(appdata_s *ad)
{
	interstitial_ad_event_callback_s callback = {0,};
	callback.interstitial_ad_opened = on_interstitial_ad_opened;
	callback.interstitial_ad_closed = on_interstitial_ad_closed;
	callback.interstitial_ad_load_request_failed = on_interstitial_ad_failed;
	callback.interstitial_ad_load_request_succeeded = on_interstitial_ad_succeeded;

	adview_add_interstitial_ad(ad->layout);
	adview_interstitial_load();
	adview_interstitial_ad_register_callbacks(&callback, ad);
}

static void
create_banner_ad(appdata_s *ad)
{
	banner_ad_event_callback_s bannercallbacks = {0,};
	bannercallbacks.banner_ad_load_request_succeeded = on_banner_ad_succeeded;
	bannercallbacks.banner_ad_load_request_failed = on_banner_ad_failed;
	bannercallbacks.banner_ad_opened = on_banner_ad_opened;


	adview_add_banner_ad(&ad->banner_handle, ad->layout, BANNER_AD_SIZE_SMALL);
	adview_banner_ad_register_callbacks(ad->banner_handle, &bannercallbacks, ad);
	adview_banner_load(ad->banner_handle);

	Evas_Object *banner_handle2;
	adview_add_banner_ad(&banner_handle2, ad->layout, BANNER_AD_SIZE_BIG);
	adview_banner_load(banner_handle2);
	adview_banner_ad_set_position(banner_handle2, BANNER_AD_POSITION_CENTER);

	adview_banner_ad_register_callbacks(banner_handle2, &bannercallbacks, ad);
}
static void
create_base_gui(appdata_s *ad)
{
	char edj_path[PATH_MAX] = {0, };
	ad->timer = NULL;
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_conformant_set(ad->win, EINA_TRUE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);

	/* Conformant */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	/* Base Layout */
	app_get_resource(EDJ_FILE, edj_path, (int)PATH_MAX);
	ad->layout = elm_layout_add(ad->win);
	elm_layout_file_set(ad->layout, edj_path, GRP_MAIN);
	elm_object_part_text_set(ad->layout, "txt_title", "Hello EFL");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	eext_object_event_callback_add(ad->layout, EEXT_CALLBACK_BACK, layout_back_cb, ad);
	elm_object_content_set(ad->conform, ad->layout);

	create_interstitial_ad(ad);
	create_banner_ad(ad);

	ad->btn = elm_button_add(ad->layout);
	elm_object_text_set(ad->btn, "LoadingIntAd");
	evas_object_smart_callback_add(ad->btn, "clicked", btn_clicked_cb, ad);
	evas_object_size_hint_weight_set(ad->btn, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(ad->btn, 0.5, 0.5);
	evas_object_show(ad->btn);
	evas_object_resize(ad->btn, ELM_SCALE_SIZE(300), ELM_SCALE_SIZE(100));
	evas_object_move(ad->btn, ELM_SCALE_SIZE(200), ELM_SCALE_SIZE(100));

	/* Show window after base gui is set up */
	evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
	   Initialize UI resources and application's data
	   If this function returns true, the main loop of application starts
	   If this function returns false, the application is terminated */
	appdata_s *ad = data;
	elm_app_base_scale_set(2.6);
	adlib_init("48b5ce06200c4227a40eedf44be6049b", "9af7cb7e889445e5bb864dd5b6a21040","_inmobi","https://i.l.inmobicdn.net/sdk/jsac/p1/inmobi.js","inmobi_conf");
	create_base_gui(ad);
	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	dlog_print(DLOG_ERROR, LOG_TAG, "Orientation changeed in app");
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);
	ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_app_main() is failed. err = %d", ret);
	}

	return ret;
}
