﻿using UnityEngine;
using System.Collections;
using Tizen.AdLib;
using System;

public class AdListener1:BannerAdListener
{
	private AdProvider adobj; 
	public AdListener1(AdProvider adobject)
	{
		adobj = adobject;
	}
	public void OnAdClicked (IntPtr handle, ErrorType err)
	{
	}
	
	public void OnAdLoadFailed (IntPtr handle, ErrorType error)
	{

	}
	
	public void OnAdLoadSucceeded (IntPtr handle, ErrorType err)
	{
		adobj.BannerAdSetVisibility (handle, true);
	}
}

public class AdListener:InterstitialAdListener
{
	public void OnAdClosed (IntPtr handle)
	{
	}
	
	public void OnAdLoadFailed (IntPtr handle, ErrorType error)
	{
	}
	
	public void OnAdLoadSucceeded (IntPtr handle)
	{
		Debug.Log ("Entered in to OnAdLoadSucceeded");
		AdProvider.Instance.InterstitialAdShow ();
	}
	
	public void OnAdOpened (IntPtr handle)
	{
	}
}

public class Paddle : MonoBehaviour {
	public float paddleSpeed = 1f;
	private Vector3 playerPos = new Vector3 (0f, -9.63f, 0f);
	AdProvider adobject = AdProvider.Instance;

	void Start () {
		IntPtr handle, handle2;
		adobject.InitAdlib ("48b5ce06200c4227a40eedf44be6049b", "9af7cb7e889445e5bb864dd5b6a21040", "_inmobi", "https://i.l.inmobicdn.net/sdk/jsac/p1/inmobi.js", "inmobi_conf");
		Debug.Log ("Entered in to start");
		AdListener1 adListener_b = new AdListener1(adobject);
		AdListener adListener_i = new AdListener();
		adobject.AddInterstitialAd ();
		adobject.InterstitialAdLoad ();
		adobject.SetInterstitialAdListener (adListener_i);
		ErrorType result = adobject.AddBannerAd (BannerAdSize.BANNER_AD_SIZE_BIG, out handle);
		Debug.Log ("Handle value:"+handle);
		adobject.BannerAdLoad (handle);

		result = adobject.AddBannerAd (BannerAdSize.BANNER_AD_SIZE_SMALL, out handle2);
		Debug.Log ("Handle value:"+handle2);
		adobject.BannerAdLoad (handle2);
		adobject.BannerAdSetPosition (handle2, BannerAdPosition.BANNER_AD_POS_TOP_CENTER);
		adobject.SetBannerAdListener (handle,adListener_b);
		adobject.SetBannerAdListener (handle2, adListener_b);

	}///
	// Update is called once per frame
	void Update () {
        if (Input.GetKeyDown(KeyCode.Escape))
        {
            adobject.DeinitAdlib();
            Application.Quit();
        }

        float xPos = transform.position.x + (Input.GetAxis ("Horizontal") * paddleSpeed);
		playerPos = new Vector3 (Mathf.Clamp (xPos, -8f, 8f), -9.63f, 0f);
		transform.position = playerPos;
	}
}

