var BG_COLOR = 0x000000;
var ACCELERATION_STEERING_RATIO = 1.5;

var stageWidth, stageHeight;
var mycanvas, stage, renderer;

var textureAssets = {};
var animations = {};

var GameManager;

var gameContainer;

var accX;

// *********** FLASH PORTED VARIABLES **********

var HORIZONTAL_VELOCITY = 40; // we have increased these values
var VERTICAL_VELOCITY = 40;

var floor;
var hero;
var monster;

var sideMonsterArray = [];
var sideMonsterProbability;
var sideMonsterClip;

var horizon_1;
var horizon_2;
var horizon_3;
var bg;

var side = 0;
var h_velocity = 0;
var v_velocity = 0;

var heroJumping = false;
var heroMoving = false;

var OCCURENCE_TRIGGER_NUMBER = 10;
var TOTAL_RANDOM_NUMBER_COUNT = 50;

var SIDE_MONSTER_OCCURENCE_TRIGGER_NUMBER = 10;
var TOTAL_SIDE_MONSTER_RANDOM_NUMBER_COUNT = 200;

var itemEventProbability;
var itemArray = [];
var itemHolderClip;

var lifePanel;

var scoreMeter;

var pointTextField;


//********* REQUEST ANIMATION FRAME SHIM *********

	window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame ||
	window.webkitRequestAnimationFrame || window.oRequestAnimationFrame;

// ***********************************************

	
//Initialize function
var init = function () {
	
	// WE NEED TO PREVENT THE TIZEN DEVICE SCREEN FROM FADING AFTER A TIME
	   tizen.power.request("SCREEN", "SCREEN_NORMAL");
	
	// WE NEED TO LOAD ALL THE ASSETS INSIDE PIXI.JS in contrary to 
	// the Flash version where you have all the assets in the asset library
	
	 var assetsToLoad = ["images/background/bg.png",
	                     "images/background/big_planet.png",
	                     "images/background/planet_big.png",
	                     "images/background/planet_ground.png",
	                     "images/background/planets_back.png",
	                     
	                     "images/collectibles/star_1.png",
	                     "images/collectibles/star_2.png",
	                     "images/collectibles/star_3.png",
	                     
	                     "images/hud/life_meter.png",
	                     "images/hud/scorer.png",
	                     "images/hud/bar.png",
	                     "images/hud/bar_bg.png",
	                     
	                     "images/obstacles/rover/rover_1.png",
	                     "images/obstacles/rover/rover_2.png",
	                     "images/obstacles/rover/rover_3.png",
	                     "images/obstacles/rover/rover_4.png",
	                     
	                     "images/obstacles/tentacle/tentacle_1.png",
	                     "images/obstacles/tentacle/tentacle_2.png",
	                     "images/obstacles/tentacle/tentacle_3.png",
	                     "images/obstacles/tentacle/tentacle_4.png",
	                     
	                     "images/player/j_front.png",
	                     "images/player/jl_1.png",
	                     "images/player/jl_2.png",
	                     "images/player/jl_3.png",
	                     "images/player/jr_1.png",
	                     "images/player/jr_2.png",
	                     "images/player/jr_3.png",
	                     "images/player/wl_front.png",
	                     "images/player/wl_1.png",
	                     "images/player/wl_2.png",
	                     "images/player/wl_3.png",
	                     "images/player/wr_1.png",
	                     "images/player/wr_2.png",
	                     "images/player/wr_3.png"]; 
	 
	 
	
	    // CREATE A NEW ASSET LOADER
		   loader = new PIXI.AssetLoader(assetsToLoad);
		// USE CALLBACK
		   loader.onComplete = onAssetsLoaded.bind(this);
		// BEGIN LOADING THE ASSETS
		   loader.load();
	   
		   
	 function onAssetsLoaded() { 
	 
		 // ****** DO HERE THINGS AFTER LOADING UP THE ASSETS *******
		 
		 console.log("1. GRAPHICAL ASSETS LOADED");
		 
		 function prepareTextures() {
			 
			 // PREPARE PIXI.JS TEXTURES from our loaded assets and assign them to the textureAssets object
			
			 console.log("2. TEXTURES PREPARED");
			 
			 	// #BACKGROUND
			 
			 textureAssets.bg = PIXI.Texture.fromImage("images/background/bg.png");
			 textureAssets.big_planet = PIXI.Texture.fromImage("images/background/big_planet.png");
			 textureAssets.planet_big = PIXI.Texture.fromImage("images/background/planet_big.png");
			 textureAssets.planet_ground = PIXI.Texture.fromImage("images/background/planet_ground.png");
			 textureAssets.planets_back = PIXI.Texture.fromImage("images/background/planets_back.png");
			 
			 	// #COLLECTIBLES
	
			 textureAssets.star_1 = PIXI.Texture.fromImage("images/collectibles/star_1.png");
			 textureAssets.star_2 = PIXI.Texture.fromImage("images/collectibles/star_2.png");
			 textureAssets.star_3 = PIXI.Texture.fromImage("images/collectibles/star_3.png");
			 
			 	// #HUD
			 
			 textureAssets.life_meter = PIXI.Texture.fromImage("images/hud/lifemeter2.png");
			 textureAssets.scorer = PIXI.Texture.fromImage("images/hud/scorer.png");
			 textureAssets.bar = PIXI.Texture.fromImage("images/hud/bar.png");
			 textureAssets.bar_bg = PIXI.Texture.fromImage("images/hud/bar_bg.png");
			
			 	// #ROVER
			 
			 textureAssets.rover_1 = PIXI.Texture.fromImage("images/obstacles/rover/rover_1.png");
			 textureAssets.rover_2 = PIXI.Texture.fromImage("images/obstacles/rover/rover_2.png");
			 textureAssets.rover_3 = PIXI.Texture.fromImage("images/obstacles/rover/rover_3.png");
			 textureAssets.rover_4 = PIXI.Texture.fromImage("images/obstacles/rover/rover_4.png");
			 
			 	// #TENTACLE
			 
			 textureAssets.tentacle_1 = PIXI.Texture.fromImage("images/obstacles/tentacle/tentacle_1.png");
			 textureAssets.tentacle_2 = PIXI.Texture.fromImage("images/obstacles/tentacle/tentacle_2.png");
			 textureAssets.tentacle_3 = PIXI.Texture.fromImage("images/obstacles/tentacle/tentacle_3.png");
			 textureAssets.tentacle_4 = PIXI.Texture.fromImage("images/obstacles/tentacle/tentacle_4.png");
			 
			 	// #PLAYER MOVEMENTS
			 
			 textureAssets.j_front = PIXI.Texture.fromImage("images/player/j_front.png");
			 
			 textureAssets.jl_1 = PIXI.Texture.fromImage("images/player/jl_1.png");
			 textureAssets.jl_2 = PIXI.Texture.fromImage("images/player/jl_2.png");
			 textureAssets.jl_3 = PIXI.Texture.fromImage("images/player/jl_3.png");
			 
			 textureAssets.jr_1 = PIXI.Texture.fromImage("images/player/jr_1.png");
			 textureAssets.jr_2 = PIXI.Texture.fromImage("images/player/jr_2.png");
			 textureAssets.jr_3 = PIXI.Texture.fromImage("images/player/jr_3.png");
			 
			 textureAssets.wl_front = PIXI.Texture.fromImage("images/player/wl_front.png");
			 
			 textureAssets.wl_1 = PIXI.Texture.fromImage("images/player/wl_1.png");
			 textureAssets.wl_2 = PIXI.Texture.fromImage("images/player/wl_2.png");
			 textureAssets.wl_3 = PIXI.Texture.fromImage("images/player/wl_3.png");
			 
			 textureAssets.wr_1 = PIXI.Texture.fromImage("images/player/wr_1.png");
			 textureAssets.wr_2 = PIXI.Texture.fromImage("images/player/wr_2.png");
			 textureAssets.wr_3 = PIXI.Texture.fromImage("images/player/wr_3.png");
		 
		 }
		 
		 
		 function createAnimationArrays() {
		 
			 // ************ CREATE PIXI.JS TEXTURE ANIMATION ORDER IN ARRAYS FROM PIXI.JS TEXTURES *************
			 
			 console.log("3. ANIMATION ARRAYS PREPARED");
			 
			 	animations.star = [textureAssets.star_1,
			 	                   textureAssets.star_2,
			 	                   textureAssets.star_3];
			 
			 	animations.rover = [textureAssets.rover_1,
			 	                    textureAssets.rover_2,
			 	                    textureAssets.rover_3,
			 	                    textureAssets.rover_4];
			 	
			 	animations.tentacle = [textureAssets.tentacle_1,
			 	                       textureAssets.tentacle_2,
			 	                       textureAssets.tentacle_3,
			 	                       textureAssets.tentacle_4];
			 	 	
			 	animations.jump_left = [textureAssets.jl_1,
			 	                        textureAssets.jl_2,
			 	                        textureAssets.jl_3];
			 	
			 	animations.jump_right = [textureAssets.jr_1,
			 	                         textureAssets.jr_2,
			 	                         textureAssets.jr_3];
			 	
			 	animations.walk_left = [textureAssets.wl_1,
			 	                        textureAssets.wl_2,
			 	                        textureAssets.wl_3];
			 	
			 	animations.walk_right = [textureAssets.wr_1,
			 	                         textureAssets.wr_2,
			 	                         textureAssets.wr_3];
		 	
		 }	
		 
		 // *******************  CREATE THE JAVASCRIPT GAME CLASSES ********************
		 
		 	function ScoreMeter(_x, _y) {
		 		
		 		this.x = _x;
		 		this.y = _y;
		 		
		 		this.container = new PIXI.DisplayObjectContainer();
		 		
		 		this.sprite = new PIXI.Sprite(textureAssets.scorer);
		 		this.container.addChild(this.sprite);
		 	    
		 	    this.scoreText = new PIXI.Text("0", {font:"35px Arial", fill:"white", align:"center"});
		     	this.scoreText.x = this.sprite.width/2 - this.scoreText.width/2 + 22;
		 	    this.scoreText.y = this.sprite.height/2 - this.scoreText.height/2;
		 	    
		 	    this.container.addChild(this.scoreText);
		 	    
		 	    this.container.x = this.x;
		 		this.container.y = this.y;
		 	    
		 	    gameContainer.addChild(this.container);
		 		
		 	}
		 	
		 	ScoreMeter.prototype.updateScore = function () {
		 		
		 		this.scoreText.setText(String(GameManager.getInstance().getPoints()));
		 		this.scoreText.x = this.sprite.width/2 - this.scoreText.width/2+ 22;
		 	    this.scoreText.y = this.sprite.height/2 - this.scoreText.height/2;
		 		
		 	}
		 	
		 	function LifePanel(_x, _y) {
		 		
		 		this.x = _x;
		 		this.y = _y;
		 		
		 		this.container = new PIXI.DisplayObjectContainer();
		
		 		// life meter background sprite
			 		this.bg = new PIXI.Sprite(textureAssets.bar_bg);
			 		this.bg.x = 85;
			 		this.bg.y = 28;
			 		this.container.addChild(this.bg);
		 		
			 	//life meter masking graphic for the bar sprite
			 		this.mask = new PIXI.Graphics();	
			 		this.mask.beginFill(0xFFFFFF);
			 		this.mask.drawRect(85, 28, 74, 24);
			 		this.mask.endFill();
			 		this.container.addChild(this.mask);	
			 		
		 		// life meter bar sprite
			 		this.bar = new PIXI.Sprite(textureAssets.bar);
			 		this.bar.x = 85;
			 		this.bar.y = 28;
			 		this.container.addChild(this.bar);

			 		this.bar.mask = this.mask;
		 		
		 		//main life meter graphic
			 		this.sprite = new PIXI.Sprite(textureAssets.life_meter);
			 		this.container.addChild(this.sprite);
		 		
		 		this.container.x = this.x;
			 	this.container.y = this.y;
			 	 
			 	gameContainer.addChild(this.container);
			 	
		 	}
		 	
		 	LifePanel.prototype.updateEnergy = function() {
		 		
		 		var pixelHealth = 85 + (this.bar.width / 100) * GameManager.getInstance().getCurrentHealth() - this.bar.width;
		 			TweenMax.to(this.bar, 0.1, { x: pixelHealth } );
		 		
		 	}
		 
		 	function Hero() {  // create our Hero class
		 		
		 		var self = this;
		 		
		 		this.x = 0;
		 		this.y = 0;
		 		
		 		this.wasHit = false;
		 		
		 		this.CLIP_OFFSET = 33;
		 		
		 		this.container = new PIXI.DisplayObjectContainer();
		 		this.container.x = this.x;
		 		this.container.y = this.y;
		 		
		 		this.anim_walk_front = new PIXI.Sprite(textureAssets.wl_front);
		 		
		 		this.width = this.anim_walk_front.width;
		 		this.height = this.anim_walk_front.height;	
		 		
		 		this.anim_walk_left = new PIXI.MovieClip(animations.walk_left);
		 		this.anim_walk_left.animationSpeed = 0.1;
		 		this.anim_walk_left.loop = true
		 		this.anim_walk_left.x -= this.CLIP_OFFSET;
		 		this.anim_walk_left.stop();
		 		
		 		this.anim_walk_right = new PIXI.MovieClip(animations.walk_right);
		 		this.anim_walk_right.animationSpeed = 0.1;
		 		this.anim_walk_right.loop = true
		 		this.anim_walk_right.x += this.CLIP_OFFSET;
		 		this.anim_walk_right.stop();
		 			
		 		this.anim_jump_front = new PIXI.Sprite(textureAssets.j_front);
		 		
				this.anim_jump_left = new PIXI.MovieClip(animations.jump_left);
				this.anim_jump_left.animationSpeed = 0.1;
		 		this.anim_jump_left.loop = true
		 		this.anim_jump_left.x -= this.CLIP_OFFSET;
		 		this.anim_jump_left.stop();
				
				this.anim_jump_right = new PIXI.MovieClip(animations.jump_right);	
				this.anim_jump_right.animationSpeed = 0.1;
		 		this.anim_jump_right.loop = true
		 		this.anim_jump_right.x += this.CLIP_OFFSET;
		 		this.anim_jump_right.stop();
		 		
		 		this.heroStateArray = [this.anim_walk_front, 
		 		                       this.anim_walk_left,
		 		                       this.anim_walk_right,
		 		                       this.anim_jump_front,
		 		                       this.anim_jump_left,
		 		                       this.anim_jump_right]; 		
		 		
		 		// Add all hero states to our container
		 		for (var i=0; i < this.heroStateArray.length; i++) {
		 			this.container.addChild(this.heroStateArray[i]);
		 		}	
		 		
		 		gameContainer.addChild(this.container);
		 		
		 		this.hitHero = function()
				{
					
		 			self.wasHit = true;
		 			self.container.alpha = 0;
					TweenMax.to(self.container, 0.1, { alpha:1, yoyo:true, repeat:40, onComplete: resetHit } );
					
				}
				
				function resetHit()
				{
					
					self.wasHit = false;
				
				}
		 		
		 		
		 	}
		 	
		 	Hero.prototype.hideAllAnimationStates = function()
		 	{

		 		for (var i=0; i < this.heroStateArray.length; i++) {
		 			this.heroStateArray[i].visible = false;
		 			
		 			// only for MovieClip stopping, which only have the playing variable
		 			if (this.heroStateArray[i].playing == true) this.heroStateArray[i].play();
		 			
		 		}
		 		
		 	}
		 	
		 	Hero.prototype.setAnimation = function(_animNum)
			{
		 		
		 		this.hideAllAnimationStates();	
		 		this.heroStateArray[_animNum].visible = true;
		 		
		 		// only for MovieClips, which by default have the playing attribute
		 		if (this.heroStateArray[_animNum].playing == false) this.heroStateArray[_animNum].play();
		 		
			}
			
		 	// *** HERO SETTERS ***
		 	
		 	Hero.prototype.setX = function(_x) {
				this.x = _x;
				this.container.x = this.x;		
			}
		 	
		 	Hero.prototype.setY = function(_y) {
				this.y = _y;
				this.container.y = this.y;
			}
		 	
		 	// *** HERO GETTERS ***
		 	
		 	Hero.prototype.getX = function() {
				return this.x;
			}
		 	
		 	Hero.prototype.getY = function() {
		 		return this.y;
			}
		 	
		 	Hero.prototype.getWidth = function() {
		 		return this.width;
			}
		 	
		 	Hero.prototype.getHeight = function() {
		 		return this.height;
			}
		 	
		 	// ********** THE COLLECTIBLE ITEM JS CLASS ***********
		 	
		 	function Collectible() {
		 		
		 		this.baseSpeed = GameManager.getInstance().getFallSpeed();
		 		this.randomSpeed = GameManager.getInstance().getRandomInt(3);
		 		
		 		this.angle = 0;
		 		
		 		this.sprite = new PIXI.MovieClip(animations.star);
		 		
		 		this.width = this.sprite.width;
		 		this.height = this.sprite.height;
		 		
		 		this.x = GameManager.getInstance().getRandomInt(stageWidth);
		 		this.y = -20 - this.height;
		 		
		 		this.sprite.x = this.x;
		 		this.sprite.y = this.y;
		 		
		 		this.isAlive = true;
		 		
		 		this.type = GameManager.getInstance().getRandomInt(2); // <-- !!! PIXI.js in contrary to flash starts the frame count from 0 not 1 !!!
		 		this.sprite.gotoAndStop(this.type);
		 	
		 	}
		 	
		 	Collectible.prototype.update = function() {
		 		
		 		
		 		if ( GameManager.getInstance().getFallSpeed() )
				{
		
					var finalSpeed = this.baseSpeed + this.randomSpeed;
					
					
					this.angle += 0.1;
					
					if (this.angle > 359) angle = 0;
					 
					this.sprite.x = this.sprite.x + Math.sin(this.angle) * 10;
					this.sprite.y += finalSpeed;
					
					this.x = this.sprite.x;
					this.y = this.sprite.y;	
					
				}
		 		
		 		
		 	}
		 	
		 	Collectible.prototype.destroy = function() {
		 		
		 		if (itemHolderClip != null) {
		 			itemHolderClip.removeChild(this.sprite);
		 		}
		 		
		 	}
		 	
		 	Collectible.prototype.fadeOut = function() {
		 	
		 		TweenMax.to(this.sprite, 0.2, {alpha:0, y: this.sprite.y + 20, ease:Sine.easeOut, onComplete:this.sprite.destroy}); 
		 		
		 	}
		 	
		 	Collectible.prototype.setAlive = function(_isAlive){
		 		
		 		this.isAlive = _isAlive;
		 		
		 	}
		 	
		 	Collectible.prototype.getAlive = function() {
		 		
		 		return this.isAlive;
		 		
		 	}
		 	
		 	Collectible.prototype.setItemType = function(_t) {
		 		
		 		this.type = _t;
		 		
		 	}
		 	
		 	Collectible.prototype.getItemType = function() {
		 		
		 		return this.type;
		 		
		 	}
		 	
		 	Collectible.prototype.getY = function() {
		 		
		 		return this.y;
		 		
		 	}
		 	
		 	Collectible.prototype.getX = function() {
		 		
		 		return this.x;
		 		
		 	}
		 	
		 	Collectible.prototype.getWidth = function() {
		 		
		 		return this.width;
		 		
		 	}
		 	
		 	Collectible.prototype.getHeight = function() {
		 		
		 		return this.height;
		 		
		 	}
		 	
		 // ************** THE MONSTER JS CLASS ***************
		 	
		 	function Monster() {
		 		var self = this;
		 		
		 		this.tentacleContainer = new PIXI.DisplayObjectContainer();
		 		
		 		this.tentacle = new PIXI.DisplayObjectContainer();
		 		
		 		this.sprite = new PIXI.MovieClip(animations.tentacle);
		 		this.sprite.animationSpeed = 0.3;
		 		this.sprite.loop = true
		 		this.sprite.play();
		 		
		 		this.sprite.y = 140;
		 		
		 		this.tentacleContainer.addChild(this.tentacle);
		 		
		 		this.tentacle.addChild(this.sprite);
		 		
		 		startMonsterAttackCycle();
		 		
		 		function startMonsterAttackCycle()
				{
					console.log("## startMonsterAttackCycle");
					TweenMax.delayedCall(4, waitUntilMovingOnScene);
				
				}
				
				function waitUntilMovingOnScene()
				{	
					
					console.log("## waitUntilMovingOnScene");
					
					var _t = GameManager.getInstance().getRandomTweenTimeFloat(2);
					
						TweenMax.delayedCall(Number(_t), moveMonster);
				}
				
				function moveMonster(_m)
				{
					
					console.log("## moveMonster");
					
					var _moveTime = GameManager.getInstance().getRandomTweenTimeFloat(2);
					
						TweenMax.to(self.tentacle, Number(_moveTime), { x: GameManager.getInstance().currentHero.getX(), ease:Sine.easeOut, onComplete: prepareAttack } );
				}
				
				
				function prepareAttack()
				{
					
					console.log("## prepareAttack");
					
					var _pt = GameManager.getInstance().getRandomTweenTimeFloat(1);
					
						TweenMax.delayedCall(Number(_pt), chooseBehaviour);
					
				}
				
				function chooseBehaviour()
				{
					
					console.log("## chooseBehaviour");
					
					if (self.tentacle.x > GameManager.getInstance().currentHero.getX() - GameManager.getInstance().currentHero.getWidth()/2 && self.tentacle.x < GameManager.getInstance().currentHero.getX() + GameManager.getInstance().currentHero.getWidth()/2)
					{
						
						TweenMax.to(self.sprite, 0.6, { y:"-70", ease: Sine.easeOut , onComplete: putWeaponDown } );
						
					}
					else
					{
						
						waitUntilMovingOnScene();
						
					}
					
				}
				
				function putWeaponDown()
				{
					
					console.log("## putWeaponDown");
					
					TweenMax.to(self.sprite, 0.3, { y:"+140", ease: Sine.easeOut , onComplete: waitUntilMovingOnScene } );
				
				}
		 		
		 		gameContainer.addChild(this.tentacleContainer);
		 		
		 	}	 	

		 	Monster.prototype.setX = function(_x) {
		 		
		 		this.tentacle.x = _x;
		 		
		 	}
		 	
		 	Monster.prototype.getX = function() {
		 		
		 		return this.tentacle.x;
		 	
		 	}
		 	
		 	Monster.prototype.setY = function(_y) {
		 		
		 		this.tentacle.y = _y;
		 			
		 	}
		 	
		 	Monster.prototype.getY = function() {
		 		
		 		return this.tentacle.y;
		 		
		 	}
		 	
		 	//////////////////
		 	
		 
		 	Monster.prototype.getSpriteX = function() {
		 		
		 		return this.sprite.x;
		 		
		 	}
		 
		 	//////////////////
		 	
		 	Monster.prototype.getSpriteY = function() {
		 		
		 		return this.tentacle.y + this.sprite.y;
		 		
		 	}
		 	
		 	
		 	Monster.prototype.getWidth = function() {
		 		
		 		return this.sprite.width;
		 		
		 	}
		 	
		 	Monster.prototype.getHeight = function() {
		 		
		 		return this.sprite.height;
		 		
		 	}
		 	
		 // ******************* THE SIDE 'MONSTER' - ROVER JS CLASS *********************
		 	
		 	function SideMonster() {
		 		
		 		this.x = 0;
		 		this.y = 0;
		 		
		 		this._type;
		 		this.currentSpeed = 5;
		 	
		 		this.sprite = new PIXI.MovieClip(animations.rover);
		 		this.sprite.animationSpeed = 0.1;
		 		this.sprite.loop = true
		 		this.sprite.play();
		 			
		 		var randType = Math.round(Math.random() * 1);	
				
				if (randType == 0) {
					this._type = "LEFT-RIGHT"; 
					this.x = 0 - this.sprite.width / 2;
					
				}
				else
				{
					this._type = "RIGHT-LEFT";
					this.x = stageWidth + this.sprite.width / 2;
				}
				
				this.sprite.x = this.x;
		 		this.sprite.y = this.y;
				
				sideMonsterClip.addChild(this.sprite);
		 		
		 	}
		 	
		 	SideMonster.prototype.update = function()
			{
				
				switch(this._type) {
					
					case "LEFT-RIGHT":
						
						this.sprite.x += this.currentSpeed;
						
					break;
					
					case "RIGHT-LEFT":
						
						this.sprite.x -= this.currentSpeed;
						
					break;
					
				}
			
				this.x = this.sprite.x;
				
			}
			
		 	SideMonster.prototype.destroy = function()
			{
				
				if (sideMonsterClip) {
					
					sideMonsterClip.removeChild(this.sprite);
					
				}
				
			}
		 		 	
		 	SideMonster.prototype.setY = function(_y) {
		 		
		 		this.sprite.y = _y;
		 		
		 	}
		 	
		 	SideMonster.prototype.setX = function(_x) {
		 		
		 		this.sprite.x = _x;
		 		
		 	}
		 	
		 	SideMonster.prototype.getX = function() {
		 		
		 		return this.sprite.x;
		 		
		 	}
		 	
		 	SideMonster.prototype.getY = function() {
		 		
		 		return this.sprite.y;
		 		
		 	}
		 	
		 	SideMonster.prototype.getWidth = function() {
		 		
		 		return this.sprite.width;
		 		
		 	}
		 	
		 	SideMonster.prototype.getHeight = function() {
		 		
		 		return this.sprite.height;
		 		
		 	}
		 	
		 	
		 // *******************  CREATE A SINGLETON GAME MANAGER (like in the flash version) **********************
		 
		 	 GameManager = ( function( window, undefined ) {
		 		  
		 		  var instance = null;

		 		  	var STAR_1_POINTS = 10;
					var STAR_2_POINTS = 30;
					var STAR_3_POINTS = 60;
					 	
					var STAR_HEALTH_LOSS = 1;
				    var ROVER_HEALTH_LOSS = 5;
					var TENTACLE_HEALTH_LOSS = 20;
		 		  
				 		  function newModule() {
				 		     
				 			var _gamePoints = 0;
				 			var _currentHealth = 100;
				 			var _currentFallSpeed = 2;				
				 		    
				 			var currentHero;
				 			
				 		// *********** HELPER FUNCTIONS ***********
				 			
				 			function getRandomInt(_maxInt)
				 			{
				 				
				 				if (_maxInt && _maxInt > 0)
				 				{
				 					var randInt = Math.round(Math.random() * _maxInt);
				 				}
				 				
				 				return randInt;
				 				
				 			}
				 			
				 			function getRandomTweenTimeFloat(_maxSeconds)
				 			{
				 				
				 				var firstNum = Math.round(Math.random() * (_maxSeconds - 1));
				 					if (firstNum < 0) firstNum = 0;
				 				
				 				var secondNum = Math.round(Math.random() * 9);
				 				
				 				if (firstNum == 0 && secondNum < 2)
				 				{
				 					secondNum = 2;
				 				}
				 				
				 				var randFloat = firstNum.toString() + "." + secondNum.toString();
				 			
				 				return randFloat;
				 				
				 			}
				 			
				 		// *********** GETTER / SETTER SECTION ***********
				 			
				 		
				 			function getFallSpeed() {
				 				
				 				return _currentFallSpeed;
				 				
				 			}
				 			
				 			function setFallSpeed(_fs) {
				 				
				 				if (_fs > -1) _currentFallSpeed = _fs;
				 				
				 			}
				 			
				 			function getPoints() {
				 				
				 				return _gamePoints;
				 				
				 			}
				 			
				 			function setPoints(_p) {
				 				
				 				_gamePoints = _p;
				 				
				 			}
				 			
				 			function getCurrentHealth() {
				 				
				 				return _currentHealth;
				 				
				 			}
				 			
				 			function setCurrentHealth(_ch) {
				 				
				 				if (_ch < 0)
				 				{
				 					_currentHealth = 0;
				 				}
				 				else
				 				{
				 					_currentHealth = _ch;
				 					
				 				}
				 				
				 			}
				 			
				 		    return {
				 		    	  		 		    	
						 	      getRandomInt : getRandomInt,
						 	      getRandomTweenTimeFloat : getRandomTweenTimeFloat,
						 	      getFallSpeed : getFallSpeed,
						 	      setFallSpeed : setFallSpeed,
						 	      getPoints : getPoints,
						 	      setPoints : setPoints,
						 	      getCurrentHealth : getCurrentHealth,
						 	      setCurrentHealth : setCurrentHealth,
						 	      currentHero : currentHero     
				 		      
				 		    };
				 		    
				 		  }
		 		  
		 		  function getInstance() {
		 		    if( ! instance ) {
		 		      instance = new newModule();
		 		    }
		 		    return instance;
		 		  }
		 		  
		 		  return {
		 			  
		 		    getInstance : getInstance,
		 		    
		 		    STAR_1_POINTS : STAR_1_POINTS,
			 	    STAR_2_POINTS : STAR_2_POINTS,
			 	    STAR_3_POINTS : STAR_3_POINTS,
			 		    
			        STAR_HEALTH_LOSS : STAR_HEALTH_LOSS,
			 	    ROVER_HEALTH_LOSS : ROVER_HEALTH_LOSS,
			 	    TENTACLE_HEALTH_LOSS : TENTACLE_HEALTH_LOSS
		 		    
		 		  };
		 		  
		 		} )(window);

		 	
		 // ******************************************************************************************************	
		 	
		 	 function enableControls() {
		 		 
		 		 window.addEventListener("devicemotion", accelerometerUpdate, true);
		 		 
		 		 stage.touchstart = stage.mousedown = function(touchdata) {
		 			 
			 			if (heroJumping == false)
						{
							v_velocity -= VERTICAL_VELOCITY;
							heroJumping = true;
							hero.setAnimation(3);
						}
		 			
		 		 }
		 		 
		 	 }
		 	 
		 	 // THE ACCELEROMETER UPDATE FUNCTION
			 function accelerometerUpdate(e) {
			    	   accX = event.accelerationIncludingGravity.x * ACCELERATION_STEERING_RATIO;
			    	   
			    	   h_velocity = -Math.round(500*((accX)/100)*1000)/1000;
			    	
			 }
		 
		 	 function buildGameScene() {
		 		 
		 		 gameContainer = new PIXI.DisplayObjectContainer();
		 		 
			 		 bg = new PIXI.Sprite(textureAssets.bg); 
			 		 	gameContainer.addChild(bg);
			 		 
			 		 horizon_1 = new PIXI.Sprite(textureAssets.planets_back); 
			 		 	gameContainer.addChild(horizon_1);
			 		 
			 		 horizon_2 = new PIXI.Sprite(textureAssets.planet_big);
			 		 	gameContainer.addChild(horizon_2);
			 		 
			 		 horizon_3 = new PIXI.Sprite(textureAssets.big_planet); 
			 		 	gameContainer.addChild(horizon_3);
			 		 	
			 		 floor = new PIXI.Sprite(textureAssets.planet_ground);
			 		 	gameContainer.addChild(floor);
			 		 
			 		 sideMonsterClip = new PIXI.DisplayObjectContainer();
			 		 	gameContainer.addChild(sideMonsterClip);
			 		 
			 		 hero = new Hero();
			 		 
			 		 GameManager.getInstance().currentHero = hero;
			 		
			 		 itemHolderClip = new PIXI.DisplayObjectContainer();
			 		 	gameContainer.addChild(itemHolderClip);
			 		 		 
				     monster = new Monster();
				 		  		 	
			 		// ************         POSITIONING THE ELEMENTS ON START      ***********
			 		// ************ THIS IS AN EQUIVALENT OF FLASH IDE POSTIIONING ***********
			 		 	
				 		horizon_1.x = Math.round(stageWidth/2 - horizon_1.width/2);
			 		 	horizon_1.y = Math.round(stageHeight * 0.2);
			 		 	
			 		 	horizon_2.x = Math.round(stageWidth/2 - horizon_2.width/2) + 100;
						horizon_2.y = Math.round(stageHeight * 0.45);
						
						horizon_3.x = Math.round(stageWidth/2 - horizon_3.width/2);
						horizon_3.y = Math.round(stageHeight * 0.55);
			 		 	
						floor.x = Math.round(stageWidth/2 - floor.width/2);
						floor.y = Math.round(stageHeight * 0.75);
						
						hero.setX(Math.round(stageWidth / 2));
						hero.setY(floor.position.y - 50);
						
						monster.setX(-200);
						
						monster.setY(floor.y + 50);
						
				 		hero.setAnimation(0);

				 		scoreMeter = new ScoreMeter(40,40);
				 		lifePanel = new LifePanel(250,40);
				 			 		
						stage.addChild(gameContainer);
		 		 
			 		 
			 		// ******************************************************************************* 
			 		 
		 	 }
		 	 
		 	 function resetElementYPositions() {

	 		 	horizon_1.y = stageHeight * 0.2;
				horizon_2.y = stageHeight * 0.45;
				horizon_3.y = stageHeight * 0.55;
			
				floor.y = stageHeight * 0.75;
				hero.setY(floor.position.y - 50);
				monster.setY(floor.position.y + 50);
		 		 
		 	 }
		 	 
		 	 
		    // FETCH THE CANVAS ELEMENT 
			   mycanvas = document.getElementById("myCanvas");
		    
		    // SET THE STAGE WIDTH AND HEIGHT
			//  stageWidth = window.innerWidth;
			//  stageHeight = window.innerHeight;	 

			   stageWidth = 720;
			   stageHeight = 1280;	 
		    
		    // CREATE A NEW PIXI.JS STAGE AND SET THE AUTOMATIC RENDERER DETECTION
			   stage = new PIXI.Stage(BG_COLOR, true); // <-- second parameter 'true' sets the stage interactivity
			  // renderer = PIXI.autoDetectRenderer(stageWidth, stageHeight, mycanvas);
			   	renderer = new PIXI.WebGLRenderer(stageWidth, stageHeight, mycanvas, true);   
			   
			/////////////// STATS.JS /////////////////
			   
			       stats = new Stats();
				   stats.setMode(0);
				   stats.domElement.style.position = 'absolute';
				   stats.domElement.style.left = '240px';
				   stats.domElement.style.top = '0px';
				   
				   document.body.appendChild( stats.domElement );
			 
			////////////  GAME INITIALISATION  /////////////		   
				   
				   prepareTextures();
				   createAnimationArrays();
				   buildGameScene();
				   enableControls();
				   	   
			///////// THE MAIN GAME RENDER LOOP ////////// 
			    
			   draw();
			   
			   function draw() {  
				  
				  stats.begin();	
				  
				  	itemEventProbability = GameManager.getInstance().getRandomInt(TOTAL_RANDOM_NUMBER_COUNT);
					
					// ********** GENERATE THE COLLECTIBLE STARS *********
					
					if (itemEventProbability == OCCURENCE_TRIGGER_NUMBER) { // CREATE AN ITEM
						
						console.log("CREATE NEW COLLECTIBLE!!!");
						
						var it = new Collectible(); // In flash we had here the ITEM() class from the FLASH IDE,
													// since we don't use the FLASH IDE, we put directly the Collectible class here
						
						itemHolderClip.addChild(it.sprite);
						itemArray.push(it);
			
					}
					
					
					for (var i = 0; i < itemArray.length; i++)
					{
						
						var item = itemArray[i];
						
						item.update(); // update 
						
						
						if (item.getY() > stageHeight)
						{
						
							if (item != null) item.destroy(); // remove the Item from the stage
							itemArray.splice(itemArray.indexOf(item), 1); // remove the item refference in the item array

							GameManager.getInstance().setCurrentHealth(GameManager.getInstance().getCurrentHealth() - GameManager.STAR_HEALTH_LOSS) ;
							
							console.log("CHECK HEALTH = " + GameManager.getInstance().getCurrentHealth());
							
							lifePanel.updateEnergy();
							
						}
						
						if (hitTest(item.getX(), item.getY(), item.getWidth(), item.getHeight(), 
								    hero.getX() + 50, hero.getY() + 90, hero.getWidth() - 50, hero.getHeight() - 80) == true 
								    && item.getAlive() == true && hero.wasHit == false) {
						
							
							item.setAlive(false);
									
							switch(item.type) {
								
								case 0:
									GameManager.getInstance().setPoints(GameManager.getInstance().getPoints() + GameManager.STAR_1_POINTS);
								break;
								
								case 1:
									GameManager.getInstance().setPoints(GameManager.getInstance().getPoints() + GameManager.STAR_2_POINTS);
								break;
								
								case 2:
									GameManager.getInstance().setPoints(GameManager.getInstance().getPoints() + GameManager.STAR_3_POINTS);
								break;
								
							}
						
							item.fadeOut(); // remove the Item from the stage
							itemArray.splice(itemArray.indexOf(item), 1); // remove the item refference in the item array
		
							scoreMeter.updateScore();
						
						}
									
						
					}
					
					// ****** GENERATE SIDE MONSTER - the rover *******
					
					sideMonsterProbability = GameManager.getInstance().getRandomInt(TOTAL_SIDE_MONSTER_RANDOM_NUMBER_COUNT);
					
					if (sideMonsterProbability == SIDE_MONSTER_OCCURENCE_TRIGGER_NUMBER && sideMonsterArray.length == 0) { // CREATE A SIDE MONSTER
						
						var sm = new SideMonster();
						
							sideMonsterArray.push(sm);
						
					}
					
					for (var s = 0; s < sideMonsterArray.length; s++)
					{
						
						var _sm = sideMonsterArray[s];
						
						_sm.update();
						_sm.setY(floor.y + 45);
						
						switch(_sm._type) {
							
							case "LEFT-RIGHT":
						
								if (_sm.getX() > stageWidth + 100)
								{
									_sm.destroy();
									sideMonsterArray.splice(sideMonsterArray.indexOf(_sm), 1);
									
								}
						
							break;
							
							case "RIGHT-LEFT":
								
								if (_sm.getX() < - 100)
								{
									_sm.destroy();
									sideMonsterArray.splice(sideMonsterArray.indexOf(_sm), 1);
									
								}
							
							break;
					
						}
						
					 // ****** CHECK SIDE MONSTER COLLISIONS WITH THE PLAYER *******
				
						if (hitTest(_sm.getX() + 30, _sm.getY() + 30, _sm.getWidth() - 30, _sm.getHeight() - 30,
							hero.getX() + 20, hero.getY() + 10, hero.getWidth() - 20, hero.getHeight() - 10) == true 
							&& hero.wasHit == false)
						{
							
							hero.hitHero();
							
							GameManager.getInstance().setCurrentHealth(GameManager.getInstance().getCurrentHealth() - GameManager.ROVER_HEALTH_LOSS) ;
				
							lifePanel.updateEnergy();
							
						}	
						
						
					}
				
					
					// ********** CHECK THE PLAYERS COLLISIONS WITH THE TENTACLE ***********
					
					if (hitTest(monster.getX() + 40, monster.getSpriteY() + 30, monster.getWidth() - 40, monster.getHeight(), 
						    hero.getX() + 20, hero.getY() + 10, hero.getWidth() - 20, hero.getHeight() - 10) == true 
						    && hero.wasHit == false) 
					{

						hero.hitHero();
						
						GameManager.getInstance().setCurrentHealth(GameManager.getInstance().getCurrentHealth() - GameManager.TENTACLE_HEALTH_LOSS) ;
						
						lifePanel.updateEnergy();
						
					}
					
					// ************ PLAYER MOVEMENT ************
				  
					  	hero.setX(hero.getX() + h_velocity);  // UPDATE THE HEROES X MOVEMENT
						hero.setY(hero.getY() + v_velocity);  // UPDATE THE HEROES Y MOVEMENT
				  
						if (Math.round(h_velocity) > 0 && heroJumping == false)
						{
						
							if(h_velocity > 5)
							{
								hero.setAnimation(2);
							}
							else
							{
								hero.setAnimation(0);
							}
							
						}
						else if (Math.round(Math.round(h_velocity))> 0 && heroJumping == true)
						{
						
							if(Math.round(h_velocity) > 5)
							{
								hero.setAnimation(5);
							}
							else
							{
								hero.setAnimation(3);
							}
							
						}
						else if (Math.round(h_velocity) < 0 && heroJumping == false)
						{
						
							if(Math.round(h_velocity) < -5)
							{
								hero.setAnimation(1);
							}
							else
							{
								hero.setAnimation(0);
							}
							
						}
						else if (Math.round(h_velocity) < 0 && heroJumping == true)
						{
						
							if (Math.round(h_velocity) < -5)
							{
								hero.setAnimation(4);
							}
							else
							{
								hero.setAnimation(3);
							}
							
						}
						
						
						//////////////// CHECK BORDERS ////////////////
						
						if (v_velocity < 80) // MAKE THE PLAYER DROP DUE TO VERTICAL VELOCITY
						{
							v_velocity += 3; // You need to tweak this value
						} 			
						
						if (hero.getX() < 0) // DON'T LET THE HERO GO THROUGH THE LEFT BORDER OF THE SCREEN
						{
							h_velocity = 0;
							hero.setX(0);
						}// we have changed here stage.stageWidth (flash version) to stageWidth (JavaScript version)
						
						if (hero.getX() > stageWidth - hero.getWidth()) // DON'T LET THE HERO GO THROUGH THE RIGHT BORDER OF THE SCREEN
						{
							h_velocity = 0;
							hero.setX(stageWidth - hero.getWidth());
						}
						
						if (hero.getY() >= floor.y) // PREVENT HERO FROM GETTING STUCK IN THE GROUND
						{
							
							heroJumping = false;
							v_velocity = 0;
							hero.setY(floor.y); 
							
						}
						
				  
				// ********** DYNAMIC POSITIONING OF THE GAME HUD AND GAME ELEMENTS **********
					
						horizon_1.y = Math.round(stageHeight * 0.32) - hero.getY() * 0.15;
						horizon_2.y = Math.round(stageHeight * 0.65) - hero.getY() * 0.25;
						horizon_3.y = Math.round(stageHeight * 0.88) - hero.getY() * 0.45;
						
						floor.y = Math.round(stageHeight * 1.25) - hero.getY() * 0.75;
						
						monster.setY((floor.position.y * 1.05) + 50);				
						
					    renderer.render(stage); 
				        requestAnimationFrame(draw); // this is the equivalent of the Flash onEnterFrame()
				        
			      stats.end();
			      
			   }
			   
			/////////////////// HELPER FUNCTIONS //////////////////////  
			   
			   function hitTest(x1, y1, w1, h1, x2, y2, w2, h2) // <== hit testing
			   {
				    if (x1 + w1 > x2)
				        if (x1 < x2 + w2)
				            if (y1 + h1 > y2)
				                if (y1 < y2 + h2)
				                return true;
			   };
			   
	 } 
		   
	// add eventListener for tizenhwkey
	document.addEventListener('tizenhwkey', function(e) {
		if(e.keyName == "back") {
			try {
				tizen.application.getCurrentApplication().exit();
			} catch (error) {
				console.error("getCurrentApplication(): " + error.message);
			}
		}
	});
};
// window.onload can work without <body onload="">
window.onload = init;