/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System;
using SystemInfo.Tizen;
using TizenOs = Tizen.System;

[assembly: Xamarin.Forms.Dependency(typeof(SystemInfoImplementation))]

namespace SystemInfo.Tizen
{
    public class SystemInfoImplementation : ISystemInfo
    {

        /// <summary>
        /// a native implement class construct method
        /// </summary>
        public SystemInfoImplementation()
        {

        }

        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool IsValidKey(string key)
        {
            return TizenOs.SystemInfo.IsValidKey(key);

        }
        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool TryGetValueToBool(string key)
        {
            bool temp;
            TizenOs.SystemInfo.TryGetValue(key, out temp);
            return temp;


        }
        /// <summary>
        /// return int type from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>int</returns>
        public int TryGetValueToInt(string key)
        {

            int temp;
            TizenOs.SystemInfo.TryGetValue(key, out temp);
            return temp;

        }
        /// <summary>
        /// return double type from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>double</returns>
        public double TryGetValueToDouble(string key)
        {

            double temp;
            TizenOs.SystemInfo.TryGetValue(key, out temp);
            return temp;

        }
        /// <summary>
        /// return string type from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>string</returns>
        public string TryGetValueToString(string key)
        {

            string temp;
            TizenOs.SystemInfo.TryGetValue(key, out temp);
            return temp;

        }
        /// <summary>
        /// return DateTime type from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>DateTime</returns>
        public DateTime TryGetValueToDateTime(string key)
        {
            DateTime temp;
            TizenOs.SystemInfo.TryGetValue(key, out temp);
            return temp;
        }

        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool IsBool(string key)
        {

            return TizenOs.SystemInfo.Is<bool>(key);

        }
        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool IsDataTime(string key)
        {

            return TizenOs.SystemInfo.Is<System.DateTime>(key);


        }
        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool IsInt(string key)
        {

            return TizenOs.SystemInfo.Is<int>(key);

        }
        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool IsDouble(string key)
        {


            return TizenOs.SystemInfo.Is<double>(key);
        }
        /// <summary>
        /// return true or false from key input
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>bool</returns>
        public bool IsString(string key)
        {

            return TizenOs.SystemInfo.Is<string>(key);


        }
    }





}
