using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace SystemInfo
{

    /// <summary>
    /// a utility class
    /// </summary>
    class Util
    {

        /// <summary>
        /// a static method to access native layer
        /// </summary>
        /// <param name="key">key</param>
        /// <returns>value</returns>
        public static string IsSupport(string key)
        {
            bool BoolValue;
            int IntValue;
            string StringValue;
            double DoubleValue;
            DateTime DatetimeValue;
            string Result = "";

            if (DependencyService.Get<ISystemInfo>().IsValidKey(key))
            {
                if (DependencyService.Get<ISystemInfo>().IsBool(key))
                {
                    BoolValue = DependencyService.Get<ISystemInfo>().TryGetValueToBool(key);
                    Result = (BoolValue ? "Supported" : "Not Supported");
                }
                else if (DependencyService.Get<ISystemInfo>().IsInt(key))
                {
                    IntValue = DependencyService.Get<ISystemInfo>().TryGetValueToInt(key);
                    Result = IntValue.ToString();
                }
                else if (DependencyService.Get<ISystemInfo>().IsString(key))
                {
                    StringValue = DependencyService.Get<ISystemInfo>().TryGetValueToString(key);
                    Result = StringValue;
                }
                else if (DependencyService.Get<ISystemInfo>().IsDouble(key))
                {
                    DoubleValue = DependencyService.Get<ISystemInfo>().TryGetValueToDouble(key);
                    Result = DoubleValue.ToString();
                }
                else if (DependencyService.Get<ISystemInfo>().IsDataTime(key))
                {
                    DatetimeValue = DependencyService.Get<ISystemInfo>().TryGetValueToDateTime(key);
                    Result = DatetimeValue.ToString();
                }

            }

            return Result;
        }
    }
}
