﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System.Collections.ObjectModel;
using Xamarin.Forms;

namespace StopWatch
{
    /// <summary>
    /// StopWatch app's main page, UI part
    /// </summary>
    public partial class MainPage : ContentPage
    {
        private Label timeLabel;
        private Label minorLabel;
        private Label scaleLabel;
        private Button startButton;
        private Button labButton;
        private Label startLabel;
        private Label lapLabel;
        private ListView lapListView;
        private ObservableCollection<LapListItem> LapList;

        private static double LAYOUT_TOP_HEIGTH = 350;
        private static double LAYOUT_BOT_HEIGTH = 240;
        private static double LAYOUT_WIDTH = 720;

        /// <summary>
        /// Create UI components
        /// </summary>
        void InitializeComponent()
        {
            Title = "STOPWATCH";

            // UI Logic Development
            // Layout UI components by using AbsoluteLayout.
            timeLabel = new Label()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "00:00:00",
                TextColor = new Color(255, 255, 255),
                HorizontalTextAlignment = TextAlignment.Center,
                FontSize = 80,
                IsVisible = true,
                MinimumWidthRequest = 650,
                MinimumHeightRequest = 150,
            };
            AbsoluteLayout.SetLayoutFlags(timeLabel, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(timeLabel, new Rectangle(130f / LAYOUT_WIDTH, 100f / LAYOUT_TOP_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            minorLabel = new Label()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = ".00",
                TextColor = new Color(255, 255, 255),
                HorizontalTextAlignment = TextAlignment.Center,
                FontSize = 50,
                IsVisible = true,
                MinimumWidthRequest = 650,
                MinimumHeightRequest = 150,
            };
            AbsoluteLayout.SetLayoutFlags(minorLabel, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(minorLabel, new Rectangle(420f / LAYOUT_WIDTH, 135f / LAYOUT_TOP_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            scaleLabel = new Label()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "  Hour        Min         Sec",
                TextColor = new Color(255, 255, 255),
                HorizontalTextAlignment = TextAlignment.Center,
                FontSize = 30,
                IsVisible = true,
                MinimumWidthRequest = 650,
                MinimumHeightRequest = 100,
            };
            AbsoluteLayout.SetLayoutFlags(scaleLabel, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(scaleLabel, new Rectangle(130f / LAYOUT_WIDTH, 230f / LAYOUT_TOP_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            startButton = new Button()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                //Text = "Start",
                WidthRequest = 100,
                HeightRequest = 100,
            };
            AbsoluteLayout.SetLayoutFlags(startButton, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(startButton, new Rectangle(160f / LAYOUT_WIDTH, 50f / LAYOUT_BOT_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            labButton = new Button()
            {
                //Text = "Lap",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                WidthRequest = 100,
                HeightRequest = 100,
            };
            AbsoluteLayout.SetLayoutFlags(labButton, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(labButton, new Rectangle(460f / LAYOUT_WIDTH, 50f / LAYOUT_BOT_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            startLabel = new Label()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "START",
                TextColor = new Color(0, 0, 0),
                FontSize = 30,
                IsVisible = true,
                HorizontalTextAlignment = TextAlignment.Center,
                MinimumWidthRequest = 100,
                MinimumHeightRequest = 150,
            };
            AbsoluteLayout.SetLayoutFlags(startLabel, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(startLabel, new Rectangle(160f / LAYOUT_WIDTH, 180f / LAYOUT_BOT_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            lapLabel = new Label()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Text = "LAP",
                TextColor = new Color(0, 0, 0),
                FontSize = 30,
                IsVisible = true,
                HorizontalTextAlignment = TextAlignment.Center,
                MinimumWidthRequest = 100,
                MinimumHeightRequest = 150,
            };
            AbsoluteLayout.SetLayoutFlags(lapLabel, AbsoluteLayoutFlags.PositionProportional);
            AbsoluteLayout.SetLayoutBounds(lapLabel, new Rectangle(460f / LAYOUT_WIDTH, 180f / LAYOUT_BOT_HEIGTH, AbsoluteLayout.AutoSize, AbsoluteLayout.AutoSize));

            //Background
            BoxView boxTop = new BoxView()
            {
                Color = new Color(0, 0, 0),
                HeightRequest = 350,
                WidthRequest = 720,
            };

            //Background
            BoxView boxBot = new BoxView()
            {
                Color = new Color(178, 235, 244),
                HeightRequest = 240,
                WidthRequest = 720,
            };

            //Use ObservableCollection to contain item data.
            //If data changed, it will sync update to ListView.
            LapList = new ObservableCollection<LapListItem>();

            //Create ListView which contain Lap items
            lapListView = new ListView()
            {
                RowHeight = 120,
                ItemTemplate = new DataTemplate(() =>
                {
                    Label index = new Label()
                    {
                        TextColor = Color.Black,
                        FontSize = 42,
                        VerticalOptions = LayoutOptions.Center,
                    };
                    //Bind label's text and itemdata's Index property
                    index.SetBinding(Label.TextProperty, new Binding("Index", BindingMode.OneWay, null, null, "   Lap {0:d}"));
                    Label time = new Label()
                    {
                        TextColor = Color.Black,
                        FontSize = 42,
                        VerticalOptions = LayoutOptions.Center,
                    };
                    // Bind label's text and itemdata's Time property
                    time.SetBinding(Label.TextProperty, new Binding("Time", BindingMode.OneWay, null, null, "    |    {0:d}"));
                    Label minor = new Label()
                    {
                        TextColor = Color.Black,
                        FontSize = 42,
                        VerticalOptions = LayoutOptions.Center,
                    };
                    // Bind label's text and itemdata's Minor property
                    minor.SetBinding(Label.TextProperty, new Binding("Minor", BindingMode.OneWay, null, null, ".{0:d}"));
                    return new ViewCell
                    {
                        View = new StackLayout
                        {
                            Orientation = StackOrientation.Horizontal,
                            VerticalOptions = LayoutOptions.Center,
                            Children =
                            {
                                index, time, minor
                            }
                        }
                    };
                }),
                ItemsSource = LapList,
            };

            this.Content = new StackLayout()
            {
                Spacing = 1,
                Children =
                {
                    //First layout contain time display UI
                    new AbsoluteLayout()
                    {
                        Children =
                        {
                            boxTop,
                            timeLabel,
                            minorLabel,
                            scaleLabel
                        }
                    },
                    //Second layout contain control button
                    new AbsoluteLayout()
                    {
                        Children =
                        {
                            boxBot,
                            startButton,
                            startLabel,
                            labButton,
                            lapLabel,
                        }
                    },
                    //Third layout contain the ListView to display Lap time.
                    new StackLayout()
                    {
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                        VerticalOptions = LayoutOptions.FillAndExpand,
                        IsVisible = true,
                        Children =
                        {
                            lapListView
                        }
                    }
                }
            };
        }

        /// <summary>
        /// item data for ListView item.
        /// </summary>
        public class LapListItem
        {
            public int Index { get; set; }
            public string Time { get; set; }
            public string Minor { get; set; }
            public LapListItem(int _index, string _time, string _minor)
            {
                Index = _index;
                Time = _time;
                Minor = _minor;
            }
        }
    }
}
