﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using Xamarin.Forms;

namespace StopWatch
{
    /// <summary>
    /// StopWatch app's main page, logic part
    /// </summary>
    public partial class MainPage : ContentPage
    {
        private static System.Diagnostics.Stopwatch stopWatch;
        private StopwatchState swState = StopwatchState.init;
        private int LapIdx = 1;
        private string timeCache = "00:00:00";
        private char[] splitChars = { '.' };

        public MainPage()
        {
            InitializeComponent();

            //Register start button's click event
            startButton.Clicked += (o, e) =>
            {
                StopwatchState curState = swState;

                if (curState == StopwatchState.init)
                {

                    startLabel.Text = "STOP";
                    swState = StopwatchState.started;

                    stopWatch.Start();
                    //TimerFunc will be invoked every 100 milliseconds, except it return false.
                    Device.StartTimer(new TimeSpan(0, 0, 0, 0, 100), TimerFunc);
                }
                else if (curState == StopwatchState.started)
                {
                    startLabel.Text = "START";
                    lapLabel.Text = "RESET";

                    stopWatch.Stop();
                    swState = StopwatchState.stopped;
                }
                else if (curState == StopwatchState.stopped)
                {
                    startLabel.Text = "STOP";
                    lapLabel.Text = "LAP";

                    stopWatch.Start();
                    swState = StopwatchState.started;

                    Device.StartTimer(new TimeSpan(0, 0, 0, 0, 100), TimerFunc);
                }
            };

            //Register lap button's click event
            labButton.Clicked += (o, e) =>
            {
                StopwatchState curState = swState;

                if (curState == StopwatchState.started)
                {
                    //Get stopwatch's time string
                    string[] ret = stopWatch.Elapsed.ToString().Split(splitChars);

                    LapList.Add(new LapListItem(LapIdx, ret[0], ret[1].Substring(0, 2)));
                    LapIdx++;
                }
                else if (curState == StopwatchState.stopped)
                {
                    //If curState is stopped, then reset timer and widget's text.
                    stopWatch.Reset();

                    LapList.Clear();

                    lapLabel.Text = "LAP";
                    timeLabel.Text = "00:00:00";
                    timeCache = "00:00:00";
                    minorLabel.Text = ".00";

                    LapIdx = 1;

                    swState = StopwatchState.init;

                }
            };

            stopWatch = new System.Diagnostics.Stopwatch();
        }

        /// <summary>
        /// Timer callback function
        /// </summary>
        /// <returns>false: stop timer; true: continue the timer</returns>
        bool TimerFunc()
        {
            StopwatchState curState = swState;

            if (curState == StopwatchState.started)
            {
                string[] ret = stopWatch.Elapsed.ToString().Split(splitChars);
                if (0 != string.Compare(timeCache, ret[0]))
                {
                    timeCache = ret[0];
                    timeLabel.Text = ret[0];
                }

                minorLabel.Text = "." + ret[1].Substring(0, 2);
            }
            else
            {
                return false;
            }

            return true;
        }
    }

    /// <summary>
    /// StopWatch status
    /// </summary>
    internal enum StopwatchState
    {
        init,
        started,
        stopped
    }
}