/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System.Collections.Generic;
using Xamarin.Forms;

namespace SNSUI
{
    /// <summary>
    /// NoticePage partial class declare.
    /// </summary>
    public class NoticePage : ContentPage
    {
        private bool contentLoaded;
        private List<ListGroup> listGroups;

        /// <summary>
        /// Initializes a new instance of the <see cref="NoticePage"/> class.
        /// </summary>
        public NoticePage()
        {
            Icon = "00_controlbar_icon_more.png";
            Title = "Notice";

            InitializeData();
            InitializeComponent();
        }

        /// <summary>
        /// Initial method for the class of NoticePage 
        /// </summary>
        void InitializeComponent()
        {
            if (contentLoaded)
            {
                return;
            }

            contentLoaded = true;

            Content = CreateSettingGroupsListView();
        }

        /// <summary>
        /// A method return ListView for the class of NoticePage 
        /// </summary>
        /// <returns>Return a list view with group header</returns>
        private ListView CreateSettingGroupsListView()
        {
            ListView listView = new ListView()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                RowHeight = (int)(App.ScreenHeight * 0.078),
                IsGroupingEnabled = true,
                GroupHeaderTemplate = MyGroupHeaderTemplate,
                ItemsSource = listGroups,
                ItemTemplate = MyListItemTemplate
            };
            return listView;
        }

        /// <summary>
        /// A method return DataTemplate for the group title of ListView
        /// </summary>
        private DataTemplate MyGroupHeaderTemplate = new DataTemplate(() =>
        {
            TextCell groupCell = new TextCell();
            groupCell.SetBinding(TextCell.TextProperty, "Title");

            return groupCell;
        });

        /// <summary>
        /// A method return DataTemplate for the item content of ListView
        /// </summary>
        private DataTemplate MyListItemTemplate = new DataTemplate(() =>
        {
            // Create views with bindings for displaying each property.
            Label nameLabel = new Label
            {
                FontSize = 20,
                Margin = new Thickness(App.ScreenWidth * 0.04, App.ScreenHeight * 0.0078, 0, 0)
            };
            nameLabel.SetBinding(Label.TextProperty, "Name");
            Switch onOff = new Switch
            {
                Margin = new Thickness(App.ScreenWidth * 0.4, 0, 0, 0)
            };
            onOff.SetBinding(Switch.IsToggledProperty, "IsOn");

            // Return an assembled ViewCell.
            return new ViewCell
            {
                View = new StackLayout
                {
                    Orientation = StackOrientation.Horizontal,
                    Children =
                    {
                        nameLabel,
                        onOff
                    }
                }
            };
        });

        /// <summary>
        /// Initial method for the class of NoticePage 
        /// </summary>
        void InitializeData()
        {
            listGroups = new List<ListGroup>();
            for (int i = 0; i < 3; ++i)
            {
                // Add empty group
                listGroups.Add(new ListGroup("\n"));
                var group = new ListGroup("Setting");
                for (int j = 0; j < 10; ++j)
                {
                    group.Add(new ListItemData
                    {
                        Name = "Account setting",
                        IsOn = true
                    });
                }

                listGroups.Add(group);
            }
        }
    }

    class ListGroup : List<ListItemData>
    {
        public string Title { get; set; }

        public ListGroup(string title)
        {
            Title = title;
        }
    }

    class ListItemData
    {
        public string Name { get; set; }
        public bool IsOn { get; set; }
    }
}
