/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace SNSUI
{
    /// <summary>
    /// NewsFeedPage partial class declare .
    /// </summary>
    public class NewsFeedPage : ContentPage
    {
        private bool contentLoaded;

        /// <summary>
        /// Initializes a new instance of the <see cref="NewsFeedPage"/> class.
        /// </summary>
        public NewsFeedPage()
        {
            Icon = "00_controlbar_icon_playlist.png";
            Title = "News Feed";

            InitializeComponent();
        }

        /// <summary>
        /// Initial method for the class of NewsFeedPage 
        /// </summary>
        void InitializeComponent()
        {
            if (contentLoaded)
            {
                return;
            }

            contentLoaded = true;

            Content = new ScrollView()
            {
                VerticalOptions = LayoutOptions.FillAndExpand,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Orientation = ScrollOrientation.Vertical,
                Content = CreateNewsFeedStackLayout()
            };
        }

        /// <summary>
        /// A method to return layout
        /// </summary>
        /// <returns>StackLayout type as result</returns>
        private StackLayout CreateNewsFeedStackLayout()
        {
            StackLayout newsfeedStack = new StackLayout()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Spacing = 20,
            };

            for (int i = 0; i < 10; i++)
            {
                newsfeedStack.Children.Add(CreateOneNewsStackLayout());
            }

            return newsfeedStack;
        }

        /// <summary>
        /// A method return StackLayout class of NewsFeedPage 
        /// </summary>
        /// <returns>a layout as result</returns>
        private StackLayout CreateOneNewsStackLayout()
        {
            Editor descEntry = new Editor()
            {
                Text = "EFL is a collection of libraries that are independent or may build on top of each-other to provide useful features that complement an OS's existing environment, rather than wrap and abstract it, trying to be their own environment and OS in its entirety.",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                IsEnabled = false
            };

            StackLayout buttonsStack = new StackLayout()
            {
                Orientation = StackOrientation.Horizontal,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.Fill,
                Spacing = 15,
                Children =
                {
                    new Button()
                    {
                        Text = "I like it",
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                    },
                    new Button()
                    {
                        Text = "Message",
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                    },
                    new Button()
                    {
                        Text = "Share",
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                    }
                },
            };

            StackLayout rootStack = new StackLayout()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.Fill,
                Spacing = 15,
                Children =
                {
                    descEntry,
                    buttonsStack,
                }
            };

            return rootStack;
        }
    }

    /// <summary>
    /// Inside class for the class of NewsFeedPage
    /// </summary>
    class NewsItem
    {
        public string Description { get; set; }
    }
}
