/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace SNSUI
{
    /// <summary>
    /// MainPage partial class declare.
    /// </summary>
    public partial class MainPage : TabbedPage
    {
        private ContentPage firstPage;
        private ContentPage secondPage;
        private ContentPage thirdPage;
        private ContentPage fourthPage;
        private bool contentLoaded;

        /// <summary>
        /// Initializes a new instance of the <see cref="MainPage"/> class.
        /// </summary>
        public MainPage()
        {
            InitializeComponent();

            CurrentPageChanged += (s, a) =>
            {
                TabbedPage tabbedPage = s as TabbedPage;
                if (tabbedPage == null)
                {
                    return;
                }
            };
        }

        /// <summary>
        /// Initial method for the class of MainPage
        /// </summary>
        void InitializeComponent()
        {
            if (contentLoaded)
            {
                return;
            }

            contentLoaded = true;

            firstPage = new NewsFeedPage();
            secondPage = new FriendsPage();
            thirdPage = new MessagePage();
            fourthPage = new NoticePage();

            Children.Add(firstPage);
            Children.Add(secondPage);
            Children.Add(thirdPage);
            Children.Add(fourthPage);
        }
    }
}