﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System.Collections.Generic;
using Xamarin.Forms;

namespace SNSUI
{
    /// NoticePage partial class declare .
    /// </summary>
    /// <remarks>
    /// NoticePage page implement class
    /// the remarks tag.
    /// </remarks>
    public class NoticePage : ContentPage
    {
        private bool _contentLoaded;
        /// <summary>
        /// Initial method for the class of NoticePage </summary>
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;

            #region UI 로직
            Icon = "SNSUI.Tizen.png"; ;
            Content = CreateSettingGroupsListView();
            #endregion
        }
        /// <summary>
        /// a method return ListView for the class of NoticePage </summary>
        /// <returns> return a listview</returns>
        private ListView CreateSettingGroupsListView()
        {
            ListView listView = new ListView()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                ItemsSource = _listGroups,
                ItemTemplate = MyDoubleTextListItemTemplate
            };
            return listView;
        }

        /// <summary>
        /// a method return DataTemplate for the class of NoticePage </summary>
        /// <param name="s"> none.</param>
        ///
        DataTemplate MyDoubleTextListItemTemplate = new DataTemplate(() =>
        {
            // Create views with bindings for displaying each property.
            Label nameLabel = new Label();
            nameLabel.SetBinding(Label.TextProperty, "Name");

            Label birthdayLabel = new Label();
            BoxView boxView = new BoxView();
            boxView.SetBinding(BoxView.ColorProperty, "FavoriteColor");

            // Return an assembled ViewCell.
            return new ViewCell
            {
                View = new StackLayout
                {
                    Padding = new Thickness(0, 5),
                    Orientation = StackOrientation.Horizontal,
                    Children =
                               {
                                    boxView,
                                    new StackLayout
                                    {
                                        VerticalOptions = LayoutOptions.Center,
                                        Spacing = 0,
                                        Children =
                                        {
                                            nameLabel,
                                            birthdayLabel
    }
}
                               }
                }
            };
        });
        List<ListGroup> _listGroups;
        /// <summary>
        /// construct method for the class of NoticePage </summary>
        /// <param name> none.</param>
        public NoticePage()
        {
            InitializeData();
            InitializeComponent();
        }
        /// <summary>
        /// Initial method for the class of NoticePage </summary>
        /// <param name> none.</param>
        ///
        void InitializeData()
        {
            _listGroups = new List<ListGroup>();
            for (int i = 0; i < 10; ++i)
            {
                // Add empty group
                _listGroups.Add(new ListGroup("\n"));
                var group = new ListGroup("Setting");
                for (int j = 0; j < 10; ++j)
                {
                    group.Add(new ListItemData
                    {
                        Title = "Account setting",
                        IsOn = true
                    });
                }

                _listGroups.Add(group);
            }
        }
    }

    class ListGroup : List<ListItemData>
    {
        public string Name { get; set; }

        public ListGroup(string name)
        {
            Name = name;
        }

        public override string ToString()
        {
            return Name;
        }
    }

    class ListItemData
    {
        public string Title { get; set; }
        public bool IsOn { get; set; }
    }
}
