﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System;
using System.Collections.Generic;
using Xamarin.Forms;
namespace SNSUI
{
    /// NewsFeedPage partial class declare .
    /// </summary>
    /// <remarks>
    /// NewsFeedPage page implement class
    /// the remarks tag.
    /// </remarks>
    public class NewsFeedPage : ContentPage
    {
        private bool _contentLoaded;
        /// <summary>
        /// initial method for the class of NewsFeedPage </summary>
        /// <param name> none.</param>
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;

            #region UI
            Icon = "SNSUI.Tizen.png";
            Content = new ScrollView()
            {
                VerticalOptions = LayoutOptions.FillAndExpand,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Orientation = ScrollOrientation.Vertical,

                Content = CreateNewsFeedStackLayout()
            };
            #endregion
        }

        /// <summary>
        /// a method to return layout
        /// </summary>
        /// <returns>StackLayout type as result</returns>
        private StackLayout CreateNewsFeedStackLayout()
        {
            StackLayout newsfeedStack = new StackLayout()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                Spacing = 20,
            };

            foreach (var item in _list)
            {
                newsfeedStack.Children.Add(CreateOneNewsStackLayout(item));
            }

            return newsfeedStack;
        }
        /// <summary>
        /// a  method return StackLayout  class of NewsFeedPage </summary>
        /// <param name="item">NewsItem type.</param>
        ///<returns>a layout as result</returns>
        private StackLayout CreateOneNewsStackLayout(NewsItem item)
        {
            Editor descEntry = new Editor()
            {
                Text = "EFL is a collection of libraries that are independent or may build on top of each-other to provide useful features that complement an OS's existing environment, rather than wrap and abstract it, trying to be their own environment and OS in its entirety.",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };

            StackLayout buttonsStack = new StackLayout()
            {
                Orientation = StackOrientation.Horizontal,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.Fill,
                Spacing = 15,
                Children =
                {
                    new Button()
                    {
                        Text = "I like it",
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                    },
                    new Button()
                    {
                        Text = "Message",
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                    },
                    new Button()
                    {
                        Text = "Share",
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                    }
                },
            };

            StackLayout rootStack = new StackLayout()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.Fill,
                Spacing = 15,
                Children =
                {
                    descEntry,
                    buttonsStack,
                }
            };

            return rootStack;
        }

        List<NewsItem> _list = new List<NewsItem>();
        /// <summary>
        /// construct method for the class of NewsFeedPage </summary>
        /// <param name> none.</param>
        ///
        public NewsFeedPage()
        {
            InitializeComponent();
        }

    }
    /// <summary>
    /// inside class for the class of NewsFeedPage </summary>
    /// <param name="s"> none.</param>
    ///
    class NewsItem
    {
        public string Description { get; set; }
    }
}
