﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System.Collections.Generic;
using Xamarin.Forms;

namespace SNSUI
{
    /// MessagePage partial class declare .
    /// </summary>
    /// <remarks>
    /// MessagePage page implement class
    /// the remarks tag.
    /// </remarks>
    public class MessagePage : ContentPage
    {
        private bool _contentLoaded;
        /// <summary>
        /// initial method for the class of MainPage </summary>
        /// <param name> none.</param>
        ///
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;
        }


        /// <summary>
        /// a method to return grid view
        /// </summary>
        /// <returns>Grid type as result</returns>
        private Grid CreateGridViewWithOverlappingImages()
        {
            Grid gridView = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };

            return gridView;
        }

        List<string> _listGridItems;

        public MessagePage()
        {
            InitializeData();
            InitializeComponent();
        }
        /// <summary>
        /// a initial method</summary>
        /// <param name> none.</param>
        ///
        void InitializeData()
        {
            _listGridItems = new List<string>();
            for (int i = 0; i < 100; ++i)
            {
                _listGridItems.Add("SNSUI.Tizen.png");
            }
        }
    }
}
