﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using Xamarin.Forms;

namespace SNSUI
{
    /// MainPage partial class declare .
    /// </summary>
    /// <remarks>
    /// MainPage page implement class
    /// the remarks tag.
    /// </remarks>
    public partial class MainPage : TabbedPage
    {

        /// <summary>
        /// construct for MainPage class
        /// </summary>
        public MainPage()
        {
            InitializeComponent();

            CurrentPageChanged += (s, a) =>
            {
                TabbedPage tabbedPage = s as TabbedPage;
                if (tabbedPage == null)
                {
                    return;
                }

                tabbedPage.Title = GetCurrentPageTitle(tabbedPage.CurrentPage);
            };
        }

        /// <summary>
        /// a method to return Pagetitle
        /// </summary>
        /// <param name="page">page as input</param>
        /// <returns>string as result</returns>
        private string GetCurrentPageTitle(Page page)
        {
            // TODO: modify this code after CurrentPage feature is supported in TabbedPage class
            if (page == _firstPage)
            {
                return "News Feed";
            }
            else if (page == _secondPage)
            {
                return "Friends";
            }
            else if (page == _thirdPage)
            {
                return "Message";
            }
            else if (page == _fourthPage)
            {
                return "Notice";
            }
            else
            {
                return "Untitle";
            }
        }

        private ContentPage _firstPage;
        private ContentPage _secondPage;
        private ContentPage _thirdPage;
        private ContentPage _fourthPage;

        private bool _contentLoaded;
        /// <summary>initial method for the class of MainPage
        /// </summary>
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;
            #region UI Logic
            _firstPage = new NewsFeedPage();
            _secondPage = new FriendsPage();
            _thirdPage = new MessagePage();
            _fourthPage = new NoticePage();

            Children.Add(_firstPage);
            Children.Add(_secondPage);
            Children.Add(_thirdPage);
            Children.Add(_fourthPage);

            Title = GetCurrentPageTitle(_firstPage);
            #endregion
        }
    }
}