﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace SNSUI
{
    using System.Collections.Generic;
    using Xamarin.Forms;

    /// <summary>
    /// FriendsPage class declare .
    /// </summary>
    /// <remarks>
    /// friend page implement class
    /// the remarks tag.
    /// </remarks>
    public class FriendsPage : ContentPage
    {
        private bool _contentLoaded;
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;

            #region UI Logic
            Icon = "SNSUI.Tizen.png";
            Content = CreateFriendsListView();
            #endregion
        }

        /// <summary>
        /// a method return ListView.</summary>
        /// <returns> none.</returns>
        private ListView CreateFriendsListView()
        {

            ListView listView = new ListView()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                ItemsSource = listItemData,
                ItemTemplate = new DataTemplate(() =>
                {
                    // Create views with bindings for displaying each property.
                    Label nameLabel = new Label();
                    nameLabel.SetBinding(Label.TextProperty, "Name");

                    Label birthdayLabel = new Label();
                    BoxView boxView = new BoxView();
                    boxView.SetBinding(BoxView.ColorProperty, "FavoriteColor");

                    // Return an assembled ViewCell.
                    return new ViewCell
                    {
                        View = new StackLayout
                        {
                            Padding = new Thickness(0, 5),
                            Orientation = StackOrientation.Horizontal,
                            Children =
                               {
                                    boxView,
                                    new StackLayout
                                    {
                                        VerticalOptions = LayoutOptions.Center,
                                        Spacing = 0,
                                        Children =
                                        {
                                            nameLabel,
                                            birthdayLabel
                                        }
                                    }
                               }
                        }
                    };
                })
            };
            return listView;
        }


        private Grid CreateFriendItemInGridLayout(object item)
        {
            View listItem = item as View;
            if (listItem == null)
            {
                //       Log.Error(App.LogTag, "listItem is null");
                return null;
            }

            StackLayout texts = new StackLayout()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                Spacing = 15,
                Children =
                {
                    new Label()
                    {
                        Text = "head",
                        FontSize = 40,
                        FontAttributes = FontAttributes.Bold,
                    },
                    new Label()
                    {
                        Text = "sub",
                        FontSize = 35,
                    }
                },
            };

            Button plusBtn = new Button()
            {
                Text = "pushButton",
                FontSize = 50,
                HorizontalOptions = LayoutOptions.CenterAndExpand,
                VerticalOptions = LayoutOptions.CenterAndExpand,
                MinimumHeightRequest = 110,
                MinimumWidthRequest = 110,
            };

            Grid mainGrid = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                MinimumHeightRequest = 150,
            };
            mainGrid.Children.Add(texts, 10, 10);
            mainGrid.Children.Add(plusBtn, 20, 30);
            return mainGrid;
        }

        private List<FriendListItemData> listItemData;
        /// <summary>
        /// construct method for class FriendsPage.</summary>
        public FriendsPage() : base()
        {
            InitializeData();
            InitializeComponent();
        }

        /// <summary>
        /// initialize method for class FriendsPage.</summary>
        void InitializeData()
        {
            listItemData = new List<FriendListItemData>();
            for (int i = 0; i < 50; ++i)
            {
                listItemData.Add(new FriendListItemData
                {
                    TextHeader = "Friend",
                    TextSub = "Will you add the friend?",
                    TextButton = "+",
                });
            }
        }
    }
    /// <summary>
    /// inside class of class FriendsPage.</summary>
    /// <param name="s"> none.</param>
    ///
    class FriendListItemData
    {
        internal string TextHeader { get; set; }
        internal string TextSub { get; set; }
        internal string TextButton { get; set; }
    }



}
