#include "simplegame.h"

#include <Elementary.h>
#include <notification.h>

Evas_Object *table;
int gameStarted = 0;
int experiment_no = 0;
int color[4][4] = { { 0, 128, 0, 255 }, { 255, 0, 0, 255 }, { 0, 0, 255, 255 },
        { 0, 0, 0, 255 } };
typedef struct appdata {
    Evas_Object *win;
    Evas_Object *conform;
    Evas_Object *bubble, *entry_game_summary;
    Evas_Object *entry_gameState;

    Evas_Object *btn[200];

} appdata_s;


static Eina_Bool IncrementalTimeCount(void *data) {
    appdata_s *ad = data;
    dlog_print(DLOG_VERBOSE, LOG_TAG, "Changing Color\n");

    int t = experiment_no % 4;

    evas_object_color_set(ad->btn[0], color[t][0], color[t][1], color[t][2],
            color[t][3]);
    experiment_no++;

    const char *text = elm_object_text_get(ad->btn[1]);
    int setInt;
    sscanf(text, "%d", &setInt);

    if (setInt > 3) {
        evas_object_show(ad->btn[7]);
    }
    if (setInt < 3) {
        evas_object_hide(ad->btn[7]);
    }

    if (setInt > 5) {
        evas_object_show(ad->btn[8]);
    }
    if (setInt < 5) {
        evas_object_hide(ad->btn[8]);
    }

    if (setInt > 7) {
        evas_object_show(ad->btn[9]);
    }
    if (setInt < 7) {
        evas_object_hide(ad->btn[9]);
    }

    if (experiment_no == 15) {

        evas_object_show(ad->entry_gameState);
        elm_object_text_set(ad->entry_gameState, "Game Finish");
        evas_object_show(ad->entry_game_summary);

        evas_object_hide(ad->btn[0]);
        evas_object_hide(ad->btn[2]);
        evas_object_hide(ad->btn[3]);
        evas_object_hide(ad->btn[4]);
        return EINA_FALSE;
    }

    return EINA_TRUE;
}

static void my_table_pack(Evas_Object *table, Evas_Object *child, int x, int y,
        int w, int h) {
    evas_object_size_hint_align_set(child, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_size_hint_weight_set(child, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_table_pack(table, child, x, y, w, h);
    evas_object_show(child);
}
static void app_terminate(void *data) {
    /* Release all resources. */
}

static void btn_tab1_cb(void *data, Evas_Object *obj, void *event_info) {

    if (gameStarted) {
        appdata_s *ad = data;
        int r, g, b, a;
        const char *text = elm_object_text_get(ad->btn[0]);
        int setInt;
        sscanf(text, "%d", &setInt);

        evas_object_color_get(ad->btn[0], &r, &g, &b, &a);
        dlog_print(DLOG_VERBOSE, "log_check", "%d %d %d %d", r, g, b, a);
        if (r == 0 && g == 0 && b == 255 && a == 255) {
            dlog_print(DLOG_VERBOSE, "log_check", "Yes");
            dlog_print(DLOG_VERBOSE, "log_check", text);

            dlog_print(DLOG_VERBOSE, "log_check", "Value %d", setInt);
            sprintf(text, "%d", setInt + 1);
            elm_object_text_set(ad->btn[1], text);

            //notification_status_monitor_message_cb_set(_notification_status_message_cb, NULL);
            notification_h noti = NULL;
            int noti_err = NOTIFICATION_ERROR_NONE;

            noti_err = notification_set_vibration(noti,
                    NOTIFICATION_VIBRATION_TYPE_DEFAULT, NULL);

            notification_status_message_post("Blue Clicked");
            //notification_status_monitor_message_cb_unset();

        } else {

            sprintf(text, "%d", setInt - 1);
            elm_object_text_set(ad->btn[1], text);
            notification_status_message_post("Wrong");
        }
    }

}

static void btn_tab2_cb(void *data, Evas_Object *obj, void *event_info) {

    if (gameStarted) {

        appdata_s *ad = data;
        int r, g, b, a;
        const char *text = elm_object_text_get(ad->btn[0]);
        int setInt;
        sscanf(text, "%d", &setInt);

        evas_object_color_get(ad->btn[0], &r, &g, &b, &a);
        dlog_print(DLOG_VERBOSE, "log_check", "%d %d %d %d", r, g, b, a);
        if (r == 0 && g == 128 && b == 0 && a == 255) {
            dlog_print(DLOG_VERBOSE, "log_check", "Yes");
            dlog_print(DLOG_VERBOSE, "log_check", text);

            dlog_print(DLOG_VERBOSE, "log_check", "Value %d", setInt);
            sprintf(text, "%d", setInt + 1);
            elm_object_text_set(ad->btn[1], text);

            notification_status_message_post("Green Clicked");

        } else {

            sprintf(text, "%d", setInt - 1);
            elm_object_text_set(ad->btn[1], text);
            notification_status_message_post("Wrong");
        }
    }

}

static void btn_tab3_cb(void *data, Evas_Object *obj, void *event_info) {
    if (gameStarted) {

        appdata_s *ad = data;
        int r, g, b, a;
        const char *text = elm_object_text_get(ad->btn[0]);
        int setInt;
        sscanf(text, "%d", &setInt);

        evas_object_color_get(ad->btn[0], &r, &g, &b, &a);
        dlog_print(DLOG_VERBOSE, "log_check", "%d %d %d %d", r, g, b, a);
        if (r == 255 && g == 0 && b == 0 && a == 255) {
            dlog_print(DLOG_VERBOSE, "log_check", "Yes");
            dlog_print(DLOG_VERBOSE, "log_check", text);

            dlog_print(DLOG_VERBOSE, "log_check", "Value %d", setInt);
            sprintf(text, "%d", setInt + 1);
            elm_object_text_set(ad->btn[1], text);

            notification_status_message_post("Red Clicked");

        } else {

            sprintf(text, "%d", setInt - 1);
            elm_object_text_set(ad->btn[1], text);
            notification_status_message_post("Wrong");

        }
    }
}

static void btn_startPlay_cb(void *data, Evas_Object *obj, void *event_info) {
    appdata_s *ad = data;
    gameStarted = 1;
    elm_object_text_set(ad->entry_gameState, "<h2>Game Started</h2>");
    evas_object_show(ad->entry_gameState);
    evas_object_hide(ad->btn[5]);
    ecore_timer_add(2, IncrementalTimeCount, ad);
    ecore_main_loop_begin();

}

static void btn_stopPlay_cb(void *data, Evas_Object *obj, void *event_info) {
    appdata_s *ad = data;
    ecore_main_loop_quit();
}

static void win_delete_request_cb(void *data, Evas_Object *obj,
        void *event_info) {
    ui_app_exit();
}

static void win_back_cb(void *data, Evas_Object *obj, void *event_info) {
    appdata_s *ad = data;
    /* Let window go to hide state. */
    elm_win_lower(ad->win);
}

static void my_table_pack_not_show(Evas_Object *table, Evas_Object *child,
        int x, int y, int w, int h) {
    evas_object_size_hint_align_set(child, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_size_hint_weight_set(child, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_table_pack(table, child, x, y, w, h);
    //evas_object_show(child);
}

static void create_base_gui(appdata_s *ad) {
    /* Window */
    ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
    elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);

    ad->win = elm_win_util_standard_add("bubble", "Bubble");
    elm_win_autodel_set(ad->win, EINA_TRUE);

    if (elm_win_wm_rotation_supported_get(ad->win)) {
        int rots[4] = { 0, 0, 0, 0 };
        elm_win_wm_rotation_available_rotations_set(ad->win,
                (const int *) (&rots), 4);
    }

    evas_object_smart_callback_add(ad->win, "delete,request",
            win_delete_request_cb,
            NULL);
    eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb,
            ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_HIDE);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND,
    EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    /* Box to put the table */
    Evas_Object *box = elm_box_add(ad->win);
    evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, box);
    evas_object_show(box);

    /* Table */
    table = elm_table_add(ad->win); // table for entry,go button and webview

    /* Make table homogenous - every cell will be the same size */
    elm_table_homogeneous_set(table, EINA_TRUE);

    /* Set padding*/
    elm_table_padding_set(table, elm_config_scale_get(),
            elm_config_scale_get());

    /* Let the table child allocation area expand within in the box */
    evas_object_size_hint_weight_set(table, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);

    /* Set table to fill width but align to bottom of box */
    evas_object_size_hint_align_set(table, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_box_pack_end(box, table);
    evas_object_show(table);

    {

            /*  Background   */
            Evas_Object *bg;
            bg = elm_bg_add(ad->win);
            elm_bg_color_set(bg, 0x7F, 0xFF, 0xD4);
            //evas_object_color_set(bg, 0, 0, 255, 255);
            my_table_pack(table, bg, 0, 0, 3, 10);

            /* Prizes */
            ad->btn[7] = elm_button_add(ad->win);
            evas_object_color_set(ad->btn[7], 255, 255, 0, 255);
            elm_object_style_set(ad->btn[7], "circle");
            my_table_pack_not_show(table, ad->btn[7], 0, 2, 1, 1);

            ad->btn[8] = elm_button_add(ad->win);
            evas_object_color_set(ad->btn[8], 255, 165, 0, 255);
            elm_object_style_set(ad->btn[8], "circle");
            my_table_pack_not_show(table, ad->btn[8], 1, 2, 1, 1);

            ad->btn[9] = elm_button_add(ad->win);
            evas_object_color_set(ad->btn[9], 238, 130, 238, 255);
            elm_object_style_set(ad->btn[9], "circle");
            my_table_pack_not_show(table, ad->btn[9], 2, 2, 1, 1);

            /* color buttons*/
            ad->btn[0] = elm_button_add(ad->win);
            evas_object_color_set(ad->btn[0], 0, 0, 255, 255);
            elm_object_text_set(ad->btn[0], "0");
            evas_object_smart_callback_add(ad->btn[0], "clicked", NULL, ad);
            my_table_pack(table, ad->btn[0], 1, 0, 1, 1);

            /* 'Add Tab' Button*/
            ad->btn[1] = elm_button_add(ad->win);
            elm_object_text_set(ad->btn[1], "0");
            evas_object_smart_callback_add(ad->btn[1], "clicked", NULL, ad);
            my_table_pack(table, ad->btn[1], 1, 3, 1, 1);

            /* 'Add Tab' Button*/
            ad->btn[5] = elm_button_add(ad->win);
            //evas_object_color_set(ad->btn[4], 255, 0, 0, 255);
            elm_object_text_set(ad->btn[5], "Start Play");
            evas_object_smart_callback_add(ad->btn[5], "clicked", btn_startPlay_cb,
                    ad);
            my_table_pack(table, ad->btn[5], 0, 5, 1, 1);

            /* 'Add Tab' Button*/
            ad->btn[6] = elm_button_add(ad->win);
            //evas_object_color_set(ad->btn[4], 255, 0, 0, 255);
            elm_object_text_set(ad->btn[6], "Double Tap: Stop Play");
            evas_object_smart_callback_add(ad->btn[6], "clicked", btn_stopPlay_cb,
                    ad);
            my_table_pack(table, ad->btn[6], 1, 5, 2, 1);
            /* entry_gameState */
                    ad->entry_gameState = elm_entry_add(ad->win);
                    elm_entry_scrollable_set(ad->entry_gameState, EINA_FALSE);
                    eext_entry_selection_back_event_allow_set(ad->entry_gameState,
                    EINA_FALSE);
                    elm_object_text_set(ad->entry_gameState, "");
                    my_table_pack_not_show(table, ad->entry_gameState, 1, 7, 1, 1);

                    ad->entry_game_summary = elm_entry_add(ad->win);
                    elm_entry_scrollable_set(ad->entry_game_summary, EINA_FALSE);
                    eext_entry_selection_back_event_allow_set(ad->entry_game_summary,
                    EINA_FALSE);
                    elm_object_text_set(ad->entry_game_summary, "Game Summary");
                    my_table_pack_not_show(table, ad->entry_game_summary, 1, 1, 1, 1);

                    /* 'Add Tab' Button*/
                    ad->btn[2] = elm_button_add(ad->win);
                    evas_object_color_set(ad->btn[2], 0, 0, 255, 255);
                    elm_object_text_set(ad->btn[2], "");

                    evas_object_smart_callback_add(ad->btn[2], "clicked", btn_tab1_cb, ad);
                    my_table_pack(table, ad->btn[2], 0, 9, 1, 1);
                    /* 'Add Tab' Button*/
                    ad->btn[3] = elm_button_add(ad->win);
                    evas_object_color_set(ad->btn[3], 0, 128, 0, 255);
                    elm_object_text_set(ad->btn[3], "");
                    evas_object_smart_callback_add(ad->btn[3], "clicked", btn_tab2_cb, ad);
                    my_table_pack(table, ad->btn[3], 1, 9, 1, 1);
                    /* 'Add Tab' Button*/
                    ad->btn[4] = elm_button_add(ad->win);
                    evas_object_color_set(ad->btn[4], 255, 0, 0, 255);
                    elm_object_text_set(ad->btn[4], "");
                    evas_object_smart_callback_add(ad->btn[4], "clicked", btn_tab3_cb, ad);
                    my_table_pack(table, ad->btn[4], 2, 9, 1, 1);

                }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool app_create(void *data) {
    /* Hook to take necessary actions before main event loop starts
     Initialize UI resources and application's data
     If this function returns true, the main loop of application starts
     If this function returns false, the application is terminated */
    appdata_s *ad = data;
    create_base_gui(ad);

    return true;
}

static void app_control(app_control_h app_control, void *data) {
    /* Handle the launch request. */
}

static void app_pause(void *data) {
    /* Take necessary actions when application becomes invisible. */
}

static void app_resume(void *data) {
    /* Take necessary actions when application becomes visible. */
}

static void ui_app_lang_changed(app_event_info_h event_info, void *user_data) {
    /*APP_EVENT_LANGUAGE_CHANGED*/
    char *locale = NULL;
    system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE,
            &locale);
    elm_language_set(locale);
    free(locale);
    return;
}

static void ui_app_orient_changed(app_event_info_h event_info, void *user_data) {
    /*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
    return;
}

static void ui_app_region_changed(app_event_info_h event_info, void *user_data) {
    /*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void ui_app_low_battery(app_event_info_h event_info, void *user_data) {
    /*APP_EVENT_LOW_BATTERY*/
}

static void ui_app_low_memory(app_event_info_h event_info, void *user_data) {
    /*APP_EVENT_LOW_MEMORY*/
}

int main(int argc, char *argv[]) {
    appdata_s ad = { 0, };
    int ret = 0;

    ui_app_lifecycle_callback_s event_callback = { 0, };
    app_event_handler_h handlers[5] = { NULL, };

    event_callback.create = app_create;
    event_callback.terminate = app_terminate;
    event_callback.pause = app_pause;
    event_callback.resume = app_resume;
    event_callback.app_control = app_control;

    ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY],
            APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
    ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY],
            APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
    ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED],
            APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
    ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED],
            APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
    ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED],
            APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);
    ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

    ret = ui_app_main(argc, argv, &event_callback, &ad);
    if (ret != APP_ERROR_NONE) {
        dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
    }

    return ret;
}
