/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using Xamarin.Forms;

namespace Settings
{
    /// <summary>
    /// The main page of the settings application.
    /// </summary>
    public class MainPage : ContentPage
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MainPage"/> class.
        /// </summary>
        public MainPage()
        {
            // This command is used for push new page in async mode,
            // the parameter pageStr is the title of the new page.
            Command<string> navigateCommand =
                new Command<string>(async (string pageStr) =>
                {
                    await this.Navigation.PushAsync(new SecondPage(pageStr));
                });

            // Title of this page.
            this.Title = "Settings";
            // Content view of this page.
            this.Content = new TableView
            {
                // A table intended to be used as a menu for selections.
                Intent = TableIntent.Menu,
                Root = new TableRoot
                {
                    // Create new TableSection and set the title.
                    new TableSection("Network connections")
                    {
                        // Create new ImageCell and set the title.
                        new ImageCell
                        {
                            // The image file path relative to Settings.Tizen->Res.
                            ImageSource = "icon/settings_wifi.png",
                            // The text to be shown in ImageCell.
                            Text = "Wi-Fi",
                            // The command to be launched when the item is clicked.
                            Command = navigateCommand,
                            // The command parameter.
                            CommandParameter = "Wi-Fi"
                        },
                        new ImageCell
                        {
                            ImageSource = "icon/settings_bluetooth.png",
                            Text = "Bluetooth",
                            Command = navigateCommand,
                            CommandParameter = "Bluetooth"
                        },
                        new ImageCell
                        {
                            ImageSource = "icon/settings_SIM_card_manager.png",
                            Text = "SIM card manager",
                            Command = navigateCommand,
                            CommandParameter = "SIM card manager"
                        },
                        new ImageCell
                        {
                            ImageSource = "icon/settings_network.png",
                            Text = "Network",
                            Command = navigateCommand,
                            CommandParameter = "Network"
                        }
                    },

                    new TableSection("Sound and display")
                    {
                        new ImageCell
                        {
                            ImageSource = "icon/settings_sound.png",
                            Text = "Sound",
                            Command = navigateCommand,
                            CommandParameter = "Sound"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_display.png",
                            Text = "Display",
                            Command = navigateCommand,
                            CommandParameter = "Display"
                        }
                    },

                    new TableSection("Personalisation")
                    {
                        new ImageCell
                        {
                            ImageSource = "icon/settings_wallpaper.png",
                            Text = "Wallpaper",
                            Command = navigateCommand,
                            CommandParameter = "Wallpaper"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_color_theme.png",
                            Text = "Color Theme",
                            Command = navigateCommand,
                            CommandParameter = "Color Theme"
                        }
                    },

                    new TableSection("User and backup")
                    {
                        new ImageCell
                        {
                            ImageSource = "icon/settings_account.png",
                            Text = "Accounts",
                            Command = navigateCommand,
                            CommandParameter = "Accounts"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_restart.png",
                            Text = "Reset",
                            Command = navigateCommand,
                            CommandParameter = "Reset"
                        }
                    },

                    new TableSection("System")
                    {
                        new ImageCell
                        {
                            ImageSource = "icon/settings_language_and_input.png",
                            Text = "Language and input",
                            Command = navigateCommand,
                            CommandParameter = "Language and input"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_date_and_time.png",
                            Text = "Date and time",
                            Command = navigateCommand,
                            CommandParameter = "Date and time"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_safetyassistance.png",
                            Text = "Safety assistance",
                            Command = navigateCommand,
                            CommandParameter = "Safety assistance"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_storage.png",
                            Text = "Storage",
                            Command = navigateCommand,
                            CommandParameter = "Storage"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_security.png",
                            Text = "Security",
                            Command = navigateCommand,
                            CommandParameter = "Security"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_privacy.png",
                            Text = "Privacy",
                            Command = navigateCommand,
                            CommandParameter = "Privacy"
                        },

                        new ImageCell
                        {
                            ImageSource = "icon/settings_about_pdevice.png",
                            Text = "About Device",
                            Command = navigateCommand,
                            CommandParameter = "About Device"
                        }
                    },
                }
            };
        }
    }
}