/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
'use strict';
var SearchResultView = Backbone.View.extend({
    tagName: 'div',

    el: '#search-result-holder',

    initialize: function () {
        this.listenTo(this.model, 'change', this.render);
    },

    render: function () {
        if (!this.template) {
            this.template = Handlebars.compile($('#search-result-template').html());
        }

        this.$el.html(this.template(this.model.attributes));
    }
});