/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
// TODO: No JSDoc comments for functions. Please use @returns @param annotations. At least for the more complex functions.
'use strict';
var SearchQueryView = Backbone.View.extend({
    tagName: 'div',

    el: '#search-query-holder',

    events: {
        'click .close': 'close',
        'submit form': 'submit'
    },

    initialize: function () {
        // Listen to changes in model and invoke 'render' function if any happen.
        this.listenTo(this.model, 'change', this.render);
    },

    /**
     * Function called when view needs rendering.
     */
    render: function () {
        if (!this.template) {
            // Get template and compile it.
            this.template = Handlebars.compile($('#search-query-template').html());
        }

        // Render template and put generated HTML inside 'el' element.
        this.$el.html(this.template(this.model.attributes));
    },

    /**
     * Closes application.
     */
    close: function () {
        tizen.application.getCurrentApplication().exit();
    },

    /**
     * Submit form event handler.
     * @param {Event} e Event object.
     */
    submit: function (e) {
        var query;

        e.preventDefault();

        query = this.$el.find('#query').val();
        if (query) {
            document.location = '#query/' + query;
        } else {
            document.location = '#';
        }
    }
});