/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
'use strict';
var SearchResult = Backbone.Model.extend({
    defaults: {
        query : null,
        start : null
    },
    /**
     * Return prepared URL for retrieving data from the server.
     * @returns {String} Prepared URL.
     */
    url: function () {
        var url, params;

        // Put config data in 'params' object, which is used to generate query string.
        params = {
            key: app.config.KEY,
            cx: app.config.CX
        };

        if (this.has('query')) {
            params.q = this.get('query');
        }

        if (this.has('start')) {
            params.start = this.get('start');
        }

        // Compose URL from params.
        url = 'https://www.googleapis.com/customsearch/v1';
        url += '?' + jQuery.param(params);

        return url;
    },
    /**
     * Override the fetch method to retrieve data only if the query was set.
     * @param {Object} options Optional options. Read more in the documentation.
     * @returns {XMLHttpRequest}
     */
    fetch: function(options) {
        if (this.has('query')) {
            /* Call parent method. */
            return Backbone.Model.prototype.fetch.call(this, options);
        }

        return;
    }
});