/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
'use strict';
var app = (function () {
    var _config, _initialize;

    _config = {
        KEY: 'PASTE_THE_KEY_HERE',
        CX:  'PASTE_THE_CX_HERE'
    };

    _initialize = function () {
        /* Create objects. */
        app.searchQuery = new SearchQuery();
        app.searchResult = new SearchResult();

        /* Create view. */
        app.searchQueryView = new SearchQueryView({model: app.searchQuery});
        app.searchResultView = new SearchResultView({model: app.searchResult});

        /* Initialize router. */
        app.router = new Router();
        Backbone.history.start();

        app.searchQueryView.render();
        app.searchResultView.render();
    };

    return {
        config: _config,
        init: _initialize
    };
}());

$(document).ready(app.init);
