/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
'use strict';
var Router = Backbone.Router.extend({
    routes: {
        '':                          'search',
        'query/:query':              'search',
        'query/:query/start/:start': 'search'
    },

    /**
     * Routing function handling all the routes.
     * @param {String} query Search query.
     * @param {Number} start Starting index of result set.
     */
    search: function (query, start) {
        // Clear app.searchResult object to erase data from previous search.
        app.searchResult.clear();

        if (query !== undefined) {
            app.searchResult.set('query', query);
            app.searchQuery.set('query', query);
        }

        if (start !== undefined) {
            app.searchResult.set('start', start);
        }

        // Fetch search result data from the server.
        app.searchResult.fetch();
    }
});