/*******************************************************************************
@author Lukasz Jagodzinski <a href="mailto:l.jagodzinsk@samsung.com">l.jagodzinsk@samsung.com</a>
Copyright (c) 2012 Samsung Electronics All Rights Reserved.
*******************************************************************************/
(function () {
    'use strict';
    // Initial sizes.
    var initialFontSize = 25,
        initialWidth    = 720,
        initialHeight   = 1280,
        calculateFontSize;

    calculateFontSize = function () {
        var currentHeight,
            scaleFactor,
            fontSize,
            scaledWidth,
            scaledHeight,
            container;

        // Get current client/screen height.
        currentHeight = window.innerHeight;

        // Calculate scale factor and scaled font size.
        scaleFactor = currentHeight / initialHeight;
        fontSize    = initialFontSize * scaleFactor;

        // Calculate scaled container size.
        scaledHeight = currentHeight;
        scaledWidth  = initialWidth * scaleFactor;

        // Set scaled container and font size.
        container = document.getElementById('container');
        container.style.width        = scaledWidth + 'px';
        container.style.height       = scaledHeight + 'px';
        document.body.style.fontSize = fontSize + 'px';
    };

    window.addEventListener('resize', calculateFontSize, false);
    window.addEventListener('load', calculateFontSize, false);
}());