#include <tizen.h>
#include <service_app.h>
#include "servicesms.h"
#include <messages.h>
#include <telephony.h>
#include <stdlib.h>
#include <system_info.h>
#include <app.h>
#include <efl_extension.h>
#include <Elementary.h>
#include <app_control.h>
#include <string.h>
#include <stdio.h>

typedef struct {
	messages_service_h service_handle;
	messages_message_h msg;
	char *G_testmsg;
} appdata_s;

static char *testmsg = NULL;
char *replace_all(const char *text, const char *replace, const char *with)
{
	/* No text to process - do nothing */
	if (text == NULL)
		return NULL;

	/*
	 * If the substrings are NULL, or the length of the text to be replaced
	 * is zero, return the current text without changes.
	 * Note that we accept zero-length strings with which to replace,
	 * as that allows to remove substrings entirely.
	 */
	if (replace == NULL || with == NULL || strlen(replace) == 0)
		return strdup(text);

	char *result = NULL;

	/* We're using Eina_Strbuf buffer for the replacement */
	Eina_Strbuf *strbuf = eina_strbuf_new();
	/* The buffer is empty, so appending simply inserts the text */
	eina_strbuf_append(strbuf, text);
	/* Replace all occurrences of the 'replace' substring */
	eina_strbuf_replace_all(strbuf, replace, with);
	/* Get the copy of the current buffer contents */
	result = strdup(eina_strbuf_string_get(strbuf));
	/* Release the buffer */
	eina_strbuf_free(strbuf);

	return result;
}

bool messages_search_callback(messages_message_h msg, int index, int result_count, int total_count, char *user_data)
{
	char *text = NULL;
	int error_code = MESSAGES_ERROR_NONE;

	/* Extract message type */
	messages_message_type_e mtype = MESSAGES_TYPE_UNKNOWN;
	error_code = messages_get_message_type(msg, &mtype);

	/* Extract message text */
	error_code = messages_get_text(msg, &text);
	testmsg = replace_all(text, "\n", "<br/>");

	return true;
}


void message_box_cb(void *data, char *phone_no)
{
	appdata_s *ad = (appdata_s *) data;
	int error_code;

	int count = -1;
	messages_create_message(MESSAGES_TYPE_SMS, &ad->msg);
	error_code = messages_open_service(&ad->service_handle);

	/* Get the number of SMS messages */
	error_code = messages_get_message_count(
			ad->service_handle,         /* The service handle */
			MESSAGES_MBOX_ALL,          /* Count messages in all message boxes */
			MESSAGES_TYPE_UNKNOWN,          /* Count only SMS messages */
			&count                      /* The result */
	);
	if (count == 0)  return;
	/* Call the search function */
	error_code = messages_foreach_message(
			ad->service_handle,         /* The service handle */
			MESSAGES_MBOX_ALL,          /* Search in all message boxes */
			MESSAGES_TYPE_SMS,          /* Find SMS messages only */
			NULL,                       /* No filtering by keyword */
			phone_no,                       /* No filtering by address */
			0,                          /* Start at the first found message */
			0,                          /* No limit (returns all found messages) */
			messages_search_callback,   /* Callback called for each found message */
			ad                       /* No additional data for the callback */
	);

}

bool service_app_create(void *data)
{
	// Todo: add your code here.

	return true;
}

void cleanup_message(messages_message_h *msg)
{
	if (msg == NULL)
		return;

	if (*msg == NULL)
		return;

	/* Destroy the previous message handle */
	int error_code = messages_destroy_message(*msg);

	*msg = NULL;
}

void service_app_terminate(void *data)
{
	// Todo: add your code here.

	appdata_s *ad = (appdata_s *) data;
	int error_code;

	cleanup_message(&ad->msg);

	error_code = messages_close_service(ad->service_handle);
	if (error_code != MESSAGES_ERROR_NONE)
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to close messages service, error: %d", error_code);
	return;
}

void service_app_control(app_control_h app_control, void *data)
{
	appdata_s *ad = (appdata_s *) data;
	char *operation;
	char *app_id;
	app_control_h reply;
	app_control_get_operation(app_control, &operation);

	if (!strcmp(operation, "http://tizen.org/appcontrol/operation/service")) {
		char *phone_number;
		app_control_get_extra_data(app_control, "47sbr7nUs6.BasicUIsmsText", &phone_number);

		app_control_create(&reply);

		app_control_get_app_id(app_control, &app_id);
		if(!strcmp(phone_number, "Success"))
		{
			app_control_add_extra_data(reply, APP_CONTROL_DATA_SELECTED, "Ok");
		}
		else
		{
			message_box_cb(ad, phone_number);
			app_control_add_extra_data(reply, APP_CONTROL_DATA_SELECTED, testmsg);
		}
		app_control_reply_to_launch_request(reply, app_control, APP_CONTROL_RESULT_SUCCEEDED);

		app_control_destroy(reply);
	}
	return;
}

static void
service_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	return;
}

static void
service_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
service_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
service_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int main(int argc, char* argv[])
{
	char ad[50] = {0,};
	service_app_lifecycle_callback_s event_callback;
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = service_app_create;
	event_callback.terminate = service_app_terminate;
	event_callback.app_control = service_app_control;

	service_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, service_app_low_battery, &ad);
	service_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, service_app_low_memory, &ad);
	service_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, service_app_lang_changed, &ad);
	service_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, service_app_region_changed, &ad);

	return service_app_main(argc, argv, &event_callback, ad);
}
