window.onload = function() {
	
	document.addEventListener('tizenhwkey', function(e) {
        if (e.keyName === "back") {
            try {
                tizen.application.getCurrentApplication().hide();
            } catch (ignore) {}
        }
    });
	
	var worker;
	var alreadyStarted=0;
	
	var mainPage = document.querySelector('#main');
	
	
	var isSupported = 0; 
	if (typeof(Worker) !== "undefined") { 			// Check Web Worker Support
		isSupported = 1; 
		}
	else { 
		alert("Web workers not supported!"); 
		}

	
	mainPage.addEventListener("click", function() {
		var contentText = document.querySelector('#content-text');
		
		if(isSupported==1 && alreadyStarted==0){	// flag if worker exists
			worker = new Worker("js/worker.js");	//generate web worker
			alreadyStarted=1;				
		}
		
		
		worker.onmessage = function(event) {		// receive msg from worker.js
			contentText.innerHTML = event.data;	    // show msg from web worker on UI
			
			if(event.data%20==0){
				tizen.power.turnScreenOn();			// turn screen on first to ensure vibration
				setTimeout(function (){	              
	                navigator.vibrate(1000);		// Vibrate for 1 second
	            }, 500);     						// vibrate slight after screen is on
			}
			
			else if(event.data==99){
				worker.terminate();					// terminate the web worker when the msg reaches 99
				worker= undefined;
				alreadyStarted = 0;
				contentText.innerHTML = "Launch";
			}
			
		};
	});
};