﻿using UnityEngine;
using System.Collections;

public class PlayerController : MonoBehaviour {

    public float speed;

	private Rigidbody rb;
	private Vector3 movement;
	private float moveX, moveY;
	private Vector3 cameraStartPosition;
	private Quaternion cameraStartRotation;
    
	void Start () {
        rb = GetComponent<Rigidbody>();
		cameraStartPosition = Camera.main.transform.position;
		cameraStartRotation = Camera.main.transform.rotation;
	}
		
    void FixedUpdate() {
		moveX = Input.acceleration.x;
		moveY = Input.acceleration.y;
		movement.Set(moveX, 0, moveY);
		rb.AddForce(movement * speed);
    }

	void OnMouseDown() {
		Camera.main.transform.position = cameraStartPosition;
		Camera.main.transform.rotation = cameraStartRotation;
	}

}