﻿using UnityEngine;
using System.Collections;

public class CameraController : MonoBehaviour {
	
	private Vector3 lastPosition;
	private Quaternion lastRotation;

	void Start() {		
		lastPosition = transform.position;
		lastRotation = transform.rotation;
	}

	void Update () {		
		transform.RotateAround(Vector3.zero, Vector3.right, -Input.GetTouch(0).deltaPosition.y/3);
		if (transform.rotation.eulerAngles.x < -30 || transform.rotation.eulerAngles.x > 30) {
			lastPosition = transform.position;
			lastRotation = transform.rotation;
		} else {
			transform.position = lastPosition;
			transform.rotation = lastRotation;
		}
	}

}