
#include "user_callbacks.h"
#include "main.h"

#include <runtime_info.h>

void _runtime_info_get_value_DATA_ROAMING_cb(void *data, Evas_Object *obj, void *event_info) /////    DATA ROAMING
{
    bool value_bool;
    int ret;

    ret = runtime_info_get_value_bool(RUNTIME_INFO_KEY_DATA_ROAMING_ENABLED, &value_bool);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_get_value_bool error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_get_value_bool error: %d", ret);
        return;
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "DATA ROAMING: %s", value_bool ? "Enabled" : "Disabled");
        PRINT_MSG("DATA ROAMING: %s", value_bool ? "Enabled" : "Disabled");
    }
}

void _runtime_info_get_GPS_cb(void *data, Evas_Object *obj, void *event_info) // GPS_STATUS
{
    int value_int;
    int ret;

    ret = runtime_info_get_value_int(RUNTIME_INFO_KEY_GPS_STATUS, &value_int);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_get_value_int error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_get_value_int error: %d", ret);
        return;
    } else {
        switch (value_int) {
        case RUNTIME_INFO_GPS_STATUS_DISABLED:
            dlog_print(DLOG_DEBUG, LOG_TAG, "GPS status: DISABLED.");
            PRINT_MSG("GPS status: DISABLED.");
            break;

        case RUNTIME_INFO_GPS_STATUS_SEARCHING:
            dlog_print(DLOG_DEBUG, LOG_TAG, "GPS status: SEARCHING.");
            PRINT_MSG("GPS status: SEARCHING.");
            break;

        case RUNTIME_INFO_GPS_STATUS_CONNECTED:
            dlog_print(DLOG_DEBUG, LOG_TAG, "GPS status: CONNECTED.");
            PRINT_MSG("GPS status: CONNECTED.");
            break;

        default:
            dlog_print(DLOG_DEBUG, LOG_TAG, "GPS status: Unknown.");
            PRINT_MSG("GPS status: Unknown.");
            break;
        }
    }
}

void create_buttons_in_main_window(appdata_s *ad)
{
    Evas_Object *display = _create_new_cd_display(ad, "Runtime info", _pop_cb);
    _new_button(ad, display, "DATA ROAMING INFO", _runtime_info_get_value_DATA_ROAMING_cb);
    _new_button(ad, display, "GPS INFO", _runtime_info_get_GPS_cb);

}
