"use strict";

classes.layers.Level = cc.Layer
        .extend({

            timer : function(sec) {
                return '<p class="count">' + sec + ' </p>'
                        + '<p class="sec"> sec remaining</p>';
            },

            ctor : function() {
                tizen.logger.info("classes.layers.Level.ctor()");
                this._super();
                this.setKeyboardEnabled(true);
                this.addExitAppButton();
                var that = this;
                this.snails = [];
                this.numberOfSnails = 0;

                this.snailToRemove = null;

                this.snailsBodies = []; // box2dweb snail body
                this.hedgehogBody; // box2dweb hedgehog body
                this.keyboardArrows = {
                    left : false,
                    right : false,
                    up : false,
                    down : false
                };

                this.initTiledMap();
                this.initSnails();
                this.initBox2d();
                var size = cc.Director.getInstance().getWinSize();

                // Timeout
                var timeDisplayer = document.getElementById("timeLeft");
                timeDisplayer.innerHTML = this.timer(game.config.timeout);

                game.startCountdown(function(time) {
                    timeDisplayer.innerHTML = that.timer(game.config.timeout);
                });

                this.scheduleUpdate();
            },

            /**
             * Update bodies position
             */
            updateBox2d : function(wor) {
                wor.Step(1 / 60, 10, 10);
                wor.DrawDebugData();
                wor.ClearForces();
            },
            update : function(dt) {
                var that = this;
                this.moveAndCheckForObstacles(this.hedgehog, dt);
                this.snails.forEach(function(snail) {
                    that.moveAndCheckForObstacles(snail, dt);
                });

                // set new box2dweb bodies positions
                this.hedgehogBody
                        .SetPosition(new Box2D.Common.Math.b2Vec2(
                                this.hedgehog.getX() / game.config.box2dScale,
                                game.config.heightInMeters
                                        - (this.hedgehog.getY() / game.config.box2dScale)));

                for ( var i = 0; i < this.snails.length; i++) {
                    this.snailsBodies[i]
                            .SetPosition(new Box2D.Common.Math.b2Vec2(
                                    this.snails[i].getX()
                                            / game.config.box2dScale,
                                    game.config.heightInMeters
                                            - (this.snails[i].getY() / game.config.box2dScale)));
                }

                if (this.snailToRemove != null) {
                    this.removeSnail(this.snailToRemove);
                    this.snailToRemove = null;
                }

            },

            /**
             * Initializes static sprite as a background
             */
            initBackground : function() {
                this.background = new classes.sprites.Background();
                this.addChild(this.background, -9);
            },

            initTiledMap : function() {
                this.tiledMap = new classes.maps.TiledMeadow();
                this.addChild(this.tiledMap, -8);

                var objectGroup = this.tiledMap.getObjectGroup("hedgehog");
                var startPoint = objectGroup.objectNamed("StartPosition");

                this.hedgehog = new classes.sprites.Hedgehog();
                this.hedgehog.setPosition(new cc.Point(startPoint.x,
                        startPoint.y));
                if (!game.config.box2dDebug)
                    this.addChild(this.hedgehog, 2);
            },

            initSnails : function() {
                if (this.tiledMap) {
                    var objectGroupSnails = this.tiledMap
                            .getObjectGroup("snails");
                    var objectSnails = objectGroupSnails.getObjects();
                    this.numberOfSnails = objectSnails.length;
                    var that = this;
                    objectSnails.forEach(function(objectSnail) {
                        var snail = new classes.sprites.Snail();
                        snail.setPosition(new cc.Point(objectSnail.x,
                                objectSnail.y));
                        that.snails.push(snail);
                        if (!game.config.box2dDebug)
                            that.addChild(snail, 1);
                    });
                }
            },

            initBox2d : function() {

                // canvas width and height in meters
                var height = game.getWindowSize().height
                        / game.config.box2dScale;
                var width = game.getWindowSize().height
                        / game.config.box2dScale;

                var fixDef = new Box2D.Dynamics.b2FixtureDef;
                fixDef.density = 1.0;
                fixDef.friction = 0.5;
                fixDef.restitution = 0.2;
                fixDef.isSensor = true;

                var bodyDef = new Box2D.Dynamics.b2BodyDef;

                bodyDef.type = Box2D.Dynamics.b2Body.b2_dynamicBody;

                // create hedgehog
                fixDef.shape = new Box2D.Collision.Shapes.b2CircleShape(
                        height / 45);
                bodyDef.position.x = width / 2;
                bodyDef.position.y = -height / 2;
                this.hedgehogBody = game.getBox2dWorld().CreateBody(bodyDef);
                this.hedgehogBody.SetUserData("hedgehog");
                this.hedgehogBody.CreateFixture(fixDef);

                // create snails
                for ( var i = 0; i < this.snails.length; i++) {

                    var ptmRatio = height / 22;// scale snail shape to graphics
                    // size on the screen
                    var v = [ [ -0.537508 * ptmRatio, -0.40000 * ptmRatio ],
                            [ 0.35833 * ptmRatio, -0.36250 * ptmRatio ],
                            [ 0.52500 * ptmRatio, 0.37083 * ptmRatio ],
                            [ -0.42917 * ptmRatio, 0.37500 * ptmRatio ] ];// vector
                    // defining shape of the snail, coordinates determined using
                    // Andengine Vertex Helper tool

                    var vecs = [];
                    for ( var j = 0; j < v.length; j++) {
                        var temp = new Box2D.Common.Math.b2Vec2();
                        temp.Set(v[j][0], v[j][1]);
                        vecs[j] = temp;
                    }
                    fixDef.shape = new Box2D.Collision.Shapes.b2PolygonShape;
                    fixDef.shape.SetAsArray(vecs, vecs.length);

                    bodyDef.position.x = this.snails[i].getX()
                            / game.config.box2dScale;
                    bodyDef.position.y = game.config.heightInMeters
                            - this.snails[i].getY() / game.config.box2dScale;
                    var snail = game.getBox2dWorld().CreateBody(bodyDef);
                    snail.SetUserData("snail");
                    snail.CreateFixture(fixDef);
                    this.snailsBodies.push(snail);
                }

                // setup debug draw
                game.setBox2dDebug();

                window.setInterval(this.updateBox2d, 1000 / 120, game
                        .getBox2dWorld());

                var b2Listener = Box2D.Dynamics.b2ContactListener;

                // Add listeners for contact
                var listener = new b2Listener;

                var that = this;

                listener.BeginContact = function(contact) {

                    if ((contact.GetFixtureA().GetBody().GetUserData() == 'hedgehog' && contact
                            .GetFixtureB().GetBody().GetUserData() == 'snail')
                            || (contact.GetFixtureA().GetBody().GetUserData() == 'snail' && contact
                                    .GetFixtureB().GetBody().GetUserData() == 'hedgehog')) {

                        for ( var i = 0; i < that.snailsBodies.length; i++) {
                            // check if it is a snail-hedgehog collision (if
                            // yes, remove the snail)
                            if (that.snailsBodies[i] === contact.GetFixtureA()
                                    .GetBody()
                                    || that.snailsBodies[i] === contact
                                            .GetFixtureB().GetBody()) {
                                that.snailToRemove = i;
                            }
                        }

                    }
                }

                game.getBox2dWorld().SetContactListener(listener);
            },

            removeSnail : function(index) {
                /**
                 * TODO: Sound effects temporary turned off
                 */
                // game.getAudio().playEffect("sounds/splat");
                this.removeChild(this.snails[index]);
                this.numberOfSnails--;
                this.snails.splice(index, 1);
                game.getBox2dWorld().DestroyBody(this.snailsBodies[index]);
                this.removeChild(this.snailsBodies[index]);
                this.snailsBodies.splice(index, 1);
                if (this.numberOfSnails === 0) {
                    alert("You win!");
                    game.changeScene(game.getScene('intro'));
                    game.stopCountdown();
                    this.removeCounter();
                }
            },

            isCollisionInArray : function(item, array) {
                var i;
                for (i = 0; i < array.length; i++) {
                    if (cc.rectIntersectsRect(item, array[i])) {
                        return true;
                    }
                }
                return false;
            },

            moveAndCheckForObstacles : function(object, dt) {
                var newPosition = object.move(dt, this.keyboardArrows);
                var newReactangle = cc.rect(newPosition.x + 2 - object.width
                        / 2, newPosition.y + 2 - object.height / 2,
                        object.width - 4, object.height - 4);
                if (!this.isCollisionInArray(newReactangle,
                        this.tiledMap.obstacles)) {
                    object.setPosition(newPosition);
                }
            },

            onKeyDown : function(key) {
                console.log(key);
                switch (key) {
                case 37:
                    this.keyboardArrows.left = true;
                    break;
                case 38:
                    this.keyboardArrows.up = true;
                    break;
                case 39:
                    this.keyboardArrows.right = true;
                    break;
                case 40:
                    this.keyboardArrows.down = true;
                    break;
                default:
                    break;
                }
            },

            onKeyUp : function(key) {
                switch (key) {
                case 37:
                    this.keyboardArrows.left = false;
                    break;
                case 38:
                    this.keyboardArrows.up = false;
                    break;
                case 39:
                    this.keyboardArrows.right = false;
                    break;
                case 40:
                    this.keyboardArrows.down = false;
                    break;
                default:
                    break;
                }
            },

            removeCounter : function() {
                var timeDisplayer = document.getElementById("timeLeft");
                timeDisplayer.innerHTML = '';
            },

            cleanGameObjects : function() {
                for ( var i = 0; i < this.snails.length; i++) {
                    this.removeChild(this.snails[i]);
                    game.getBox2dWorld().DestroyBody(this.snailsBodies[i]);
                    this.removeChild(this.snailsBodies[i]);
                }
                game.getBox2dWorld().DestroyBody(this.hedgehogBody);
            }
        });