/*
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008, Luke Benstead.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

cc.km_mat4_stack = function(capacity, item_count, top, stack){
    this.capacity = capacity || 0;      //The total item capacity
    this.item_count = item_count || 0;  //The number of items
    this.top = top ;
    this.stack = stack ;
};

cc.km_mat4_stack.INITIAL_SIZE = 30;
cc.km_mat4_stack.INCREMENT = 50;

cc.km_mat4_stack_initialize = function(stack){
    stack.stack = []; //allocate the memory
    stack.capacity = cc.km_mat4_stack.INITIAL_SIZE;
    stack.top = null; //Set the top to NULL
    stack.item_count = 0;
};

cc.km_mat4_stack_push = function(stack, item){
    stack.stack.push(stack.top);
    stack.top = new cc.kmMat4();
    cc.kmMat4Assign(stack.top, item);
    stack.item_count++;
};

cc.km_mat4_stack_pop = function(stack, pOut){
    //cc.Assert(stack.item_count , "Cannot pop an empty stack");
    stack.item_count--;
    stack.top = stack.stack.pop();
};

cc.km_mat4_stack_release = function(stack){
    stack.stack = null;
    stack.top = null;
    stack.item_count = 0;
    stack.capacity = 0;
    stack = null;
};




