package org.tizen.gwt.sample.raphaelpaint.client.overlay;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;

public class Raphael extends JavaScriptObject {

	public interface ReadyCallback {

		void onRaphaelReady();
	}
	
	public static final native Raphael create(Element container, int width, int height) /*-{
		return $wnd.Raphael(container, width, height);
	}-*/;
	
	public static final native void addReadyCallback(ReadyCallback callback) /*-{
		$wnd.Raphael(function() {
			callback.@org.tizen.gwt.sample.raphaelpaint.client.overlay.Raphael.ReadyCallback::onRaphaelReady()();
			callback = null;
		});
	}-*/;
	
	public static final native RaphaelColor createColor(String color) /*-{
		return $wnd.Raphael.color(color);
	}-*/;
	
	protected Raphael() {}
	
	public final native RaphaelElement rect(double x, double y, double width, double height) /*-{
		return this.rect(x, y, width, height);
	}-*/;
	
	public final native RaphaelElement circle(double x, double y, double radius) /*-{
		return this.circle(x, y, radius);
	}-*/;
	
	public final native RaphaelElement ellipse(double x, double y, double rx, double ry) /*-{
		return this.ellipse(x, y, rx, ry);
	}-*/;

	public final native RaphaelElement path(String pathString) /*-{
		return this.path(pathString);
	}-*/;

	public final native RaphaelElement getElementByPoint(double x, double y) /*-{
		return this.getElementByPoint(x, y);
	}-*/;

	public final native void clear() /*-{
		this.clear();
	}-*/;
}